/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.http.snoop;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.example.http.snoop.HttpSnoopClientInitializer;
import io.netty.handler.codec.http.ClientCookieEncoder;
import io.netty.handler.codec.http.Cookie;
import io.netty.handler.codec.http.DefaultCookie;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import java.net.URI;

public class HttpSnoopClient {
    private final URI uri;

    public HttpSnoopClient(URI uri) {
        this.uri = uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        String scheme = this.uri.getScheme() == null ? "http" : this.uri.getScheme();
        String host = this.uri.getHost() == null ? "localhost" : this.uri.getHost();
        int port = this.uri.getPort();
        if (port == -1) {
            if ("http".equalsIgnoreCase(scheme)) {
                port = 80;
            } else if ("https".equalsIgnoreCase(scheme)) {
                port = 443;
            }
        }
        if (!"http".equalsIgnoreCase(scheme) && !"https".equalsIgnoreCase(scheme)) {
            System.err.println("Only HTTP(S) is supported.");
            return;
        }
        boolean ssl = "https".equalsIgnoreCase(scheme);
        NioEventLoopGroup group = new NioEventLoopGroup();
        try {
            Bootstrap b = new Bootstrap();
            ((Bootstrap)((Bootstrap)b.group((EventLoopGroup)group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new HttpSnoopClientInitializer(ssl));
            Channel ch = b.connect(host, port).sync().channel();
            DefaultHttpRequest request = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, this.uri.getRawPath());
            request.headers().set("Host", (Object)host);
            request.headers().set("Connection", (Object)"close");
            request.headers().set("Accept-Encoding", (Object)"gzip");
            request.headers().set("Cookie", (Object)ClientCookieEncoder.encode((Cookie[])new Cookie[]{new DefaultCookie("my-cookie", "foo"), new DefaultCookie("another-cookie", "bar")}));
            ch.writeAndFlush((Object)request);
            ch.closeFuture().sync();
        }
        finally {
            group.shutdownGracefully();
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.err.println("Usage: " + HttpSnoopClient.class.getSimpleName() + " <URL>");
            return;
        }
        URI uri = new URI(args[0]);
        new HttpSnoopClient(uri).run();
    }
}

