/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.http2.helloworld.multiplex.server;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http2.DefaultHttp2DataFrame;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.DefaultHttp2HeadersFrame;
import io.netty.handler.codec.http2.Http2DataFrame;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;

@ChannelHandler.Sharable
public class HelloWorldHttp2Handler
extends ChannelDuplexHandler {
    static final ByteBuf RESPONSE_BYTES = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.copiedBuffer((CharSequence)"Hello World", (Charset)CharsetUtil.UTF_8)).asReadOnly();

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        super.exceptionCaught(ctx, cause);
        cause.printStackTrace();
        ctx.close();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof Http2HeadersFrame) {
            HelloWorldHttp2Handler.onHeadersRead(ctx, (Http2HeadersFrame)msg);
        } else if (msg instanceof Http2DataFrame) {
            HelloWorldHttp2Handler.onDataRead(ctx, (Http2DataFrame)msg);
        } else {
            super.channelRead(ctx, msg);
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }

    private static void onDataRead(ChannelHandlerContext ctx, Http2DataFrame data) throws Exception {
        if (data.isEndStream()) {
            HelloWorldHttp2Handler.sendResponse(ctx, data.content());
        } else {
            data.release();
        }
    }

    private static void onHeadersRead(ChannelHandlerContext ctx, Http2HeadersFrame headers) throws Exception {
        if (headers.isEndStream()) {
            ByteBuf content = ctx.alloc().buffer();
            content.writeBytes(RESPONSE_BYTES.duplicate());
            ByteBufUtil.writeAscii((ByteBuf)content, (CharSequence)" - via HTTP/2");
            HelloWorldHttp2Handler.sendResponse(ctx, content);
        }
    }

    private static void sendResponse(ChannelHandlerContext ctx, ByteBuf payload) {
        Http2Headers headers = new DefaultHttp2Headers().status((CharSequence)HttpResponseStatus.OK.codeAsText());
        ctx.write((Object)new DefaultHttp2HeadersFrame(headers));
        ctx.write((Object)new DefaultHttp2DataFrame(payload, true));
    }
}

