/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.worldclock;

import com.google.protobuf.MessageLite;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.example.worldclock.WorldClockClient;
import io.netty.example.worldclock.WorldClockClientHandler;
import io.netty.example.worldclock.WorldClockProtocol;
import io.netty.handler.codec.protobuf.ProtobufDecoder;
import io.netty.handler.codec.protobuf.ProtobufEncoder;
import io.netty.handler.codec.protobuf.ProtobufVarint32FrameDecoder;
import io.netty.handler.codec.protobuf.ProtobufVarint32LengthFieldPrepender;
import io.netty.handler.ssl.SslContext;

public class WorldClockClientInitializer
extends ChannelInitializer<SocketChannel> {
    private final SslContext sslCtx;

    public WorldClockClientInitializer(SslContext sslCtx) {
        this.sslCtx = sslCtx;
    }

    public void initChannel(SocketChannel ch) {
        ChannelPipeline p = ch.pipeline();
        if (this.sslCtx != null) {
            p.addLast(new ChannelHandler[]{this.sslCtx.newHandler(ch.alloc(), WorldClockClient.HOST, WorldClockClient.PORT)});
        }
        p.addLast(new ChannelHandler[]{new ProtobufVarint32FrameDecoder()});
        p.addLast(new ChannelHandler[]{new ProtobufDecoder((MessageLite)WorldClockProtocol.LocalTimes.getDefaultInstance())});
        p.addLast(new ChannelHandler[]{new ProtobufVarint32LengthFieldPrepender()});
        p.addLast(new ChannelHandler[]{new ProtobufEncoder()});
        p.addLast(new ChannelHandler[]{new WorldClockClientHandler()});
    }
}

