/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.channel.ChannelTaskScheduler;
import io.netty.channel.EventExecutor;
import io.netty.channel.EventExecutorGroup;
import io.netty.logging.InternalLogger;
import io.netty.logging.InternalLoggerFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public abstract class SingleThreadEventExecutor
extends AbstractExecutorService
implements EventExecutor {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SingleThreadEventExecutor.class);
    static final ThreadLocal<SingleThreadEventExecutor> CURRENT_EVENT_LOOP = new ThreadLocal();
    private final EventExecutorGroup parent;
    private final Queue<Runnable> taskQueue;
    private final Thread thread;
    private final Object stateLock = new Object();
    private final Semaphore threadLock = new Semaphore(0);
    private final ChannelTaskScheduler scheduler;
    private final Set<Runnable> shutdownHooks = new LinkedHashSet<Runnable>();
    private volatile int state;

    public static SingleThreadEventExecutor currentEventLoop() {
        return CURRENT_EVENT_LOOP.get();
    }

    protected SingleThreadEventExecutor(EventExecutorGroup parent, ThreadFactory threadFactory, ChannelTaskScheduler scheduler) {
        if (threadFactory == null) {
            throw new NullPointerException("threadFactory");
        }
        if (scheduler == null) {
            throw new NullPointerException("scheduler");
        }
        this.parent = parent;
        this.scheduler = scheduler;
        this.thread = threadFactory.newThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CURRENT_EVENT_LOOP.set(SingleThreadEventExecutor.this);
                try {
                    SingleThreadEventExecutor.this.run();
                }
                finally {
                    try {
                        try {
                            this.cleanupTasks();
                        }
                        finally {
                            Object object = SingleThreadEventExecutor.this.stateLock;
                            synchronized (object) {
                                SingleThreadEventExecutor.this.state = 3;
                            }
                        }
                        this.cleanupTasks();
                    }
                    finally {
                        try {
                            SingleThreadEventExecutor.this.cleanup();
                        }
                        finally {
                            SingleThreadEventExecutor.this.threadLock.release();
                            assert (SingleThreadEventExecutor.this.taskQueue.isEmpty());
                        }
                    }
                }
            }

            private void cleanupTasks() {
                do {
                    boolean ran = false;
                    ran |= SingleThreadEventExecutor.this.runAllTasks();
                } while ((ran |= SingleThreadEventExecutor.this.runShutdownHooks()) || SingleThreadEventExecutor.this.hasTasks());
            }
        });
        this.taskQueue = this.newTaskQueue();
    }

    protected Queue<Runnable> newTaskQueue() {
        return new LinkedBlockingQueue<Runnable>();
    }

    @Override
    public EventExecutorGroup parent() {
        return this.parent;
    }

    @Override
    public EventExecutor next() {
        return this;
    }

    protected void interruptThread() {
        this.thread.interrupt();
    }

    protected Runnable pollTask() {
        assert (this.inEventLoop());
        return this.taskQueue.poll();
    }

    protected Runnable takeTask() throws InterruptedException {
        assert (this.inEventLoop());
        if (this.taskQueue instanceof BlockingQueue) {
            return (Runnable)((BlockingQueue)this.taskQueue).take();
        }
        throw new UnsupportedOperationException();
    }

    protected Runnable peekTask() {
        assert (this.inEventLoop());
        return this.taskQueue.peek();
    }

    protected boolean hasTasks() {
        assert (this.inEventLoop());
        return !this.taskQueue.isEmpty();
    }

    protected void addTask(Runnable task) {
        if (task == null) {
            throw new NullPointerException("task");
        }
        if (this.isShutdown()) {
            SingleThreadEventExecutor.reject();
        }
        this.taskQueue.add(task);
    }

    protected boolean removeTask(Runnable task) {
        if (task == null) {
            throw new NullPointerException("task");
        }
        return this.taskQueue.remove(task);
    }

    protected boolean runAllTasks() {
        Runnable task;
        boolean ran = false;
        while ((task = this.pollTask()) != null) {
            try {
                task.run();
                ran = true;
            }
            catch (Throwable t) {
                logger.warn("A task raised an exception.", t);
            }
        }
        return ran;
    }

    protected abstract void run();

    protected void cleanup() {
    }

    protected abstract void wakeup(boolean var1);

    @Override
    public boolean inEventLoop() {
        return this.inEventLoop(Thread.currentThread());
    }

    @Override
    public boolean inEventLoop(Thread thread) {
        return thread == this.thread;
    }

    public void addShutdownHook(final Runnable task) {
        if (this.inEventLoop()) {
            this.shutdownHooks.add(task);
        } else {
            this.execute(new Runnable(){

                @Override
                public void run() {
                    SingleThreadEventExecutor.this.shutdownHooks.add(task);
                }
            });
        }
    }

    public void removeShutdownHook(final Runnable task) {
        if (this.inEventLoop()) {
            this.shutdownHooks.remove(task);
        } else {
            this.execute(new Runnable(){

                @Override
                public void run() {
                    SingleThreadEventExecutor.this.shutdownHooks.remove(task);
                }
            });
        }
    }

    private boolean runShutdownHooks() {
        boolean ran = false;
        while (!this.shutdownHooks.isEmpty()) {
            ArrayList<Runnable> copy = new ArrayList<Runnable>(this.shutdownHooks);
            this.shutdownHooks.clear();
            for (Runnable task : copy) {
                try {
                    task.run();
                    ran = true;
                }
                catch (Throwable t) {
                    logger.warn("Shutdown hook raised an exception.", t);
                }
            }
        }
        return ran;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        boolean inEventLoop = this.inEventLoop();
        boolean wakeup = false;
        if (inEventLoop) {
            Object object = this.stateLock;
            synchronized (object) {
                assert (this.state == 1);
                this.state = 2;
                wakeup = true;
            }
        }
        Object object = this.stateLock;
        synchronized (object) {
            switch (this.state) {
                case 0: {
                    this.state = 3;
                    try {
                        this.cleanup();
                        break;
                    }
                    finally {
                        this.threadLock.release();
                    }
                }
                case 1: {
                    this.state = 2;
                    wakeup = true;
                }
            }
        }
        if (wakeup) {
            this.wakeup(inEventLoop);
        }
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.shutdown();
        return Collections.emptyList();
    }

    @Override
    public boolean isShutdown() {
        return this.state >= 2;
    }

    @Override
    public boolean isTerminated() {
        return this.state == 3;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        if (unit == null) {
            throw new NullPointerException("unit");
        }
        if (this.inEventLoop()) {
            throw new IllegalStateException("cannot await termination of the current thread");
        }
        if (this.threadLock.tryAcquire(timeout, unit)) {
            this.threadLock.release();
        }
        return this.isTerminated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Runnable task) {
        if (task == null) {
            throw new NullPointerException("task");
        }
        if (this.inEventLoop()) {
            this.addTask(task);
            this.wakeup(true);
        } else {
            Object object = this.stateLock;
            synchronized (object) {
                if (this.state == 0) {
                    this.state = 1;
                    this.thread.start();
                }
            }
            this.addTask(task);
            if (this.isShutdown() && this.removeTask(task)) {
                SingleThreadEventExecutor.reject();
            }
            this.wakeup(false);
        }
    }

    private static void reject() {
        throw new RejectedExecutionException("event executor shut down");
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.scheduler.schedule((EventExecutor)this, command, delay, unit);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return this.scheduler.schedule((EventExecutor)this, callable, delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.scheduler.scheduleAtFixedRate(this, command, initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.scheduler.scheduleWithFixedDelay(this, command, initialDelay, delay, unit);
    }
}

