/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.buffer.BufUtil;
import io.netty.buffer.MessageBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOperationHandlerAdapter;
import io.netty.channel.ChannelOutboundMessageHandler;
import io.netty.channel.ChannelPromise;
import io.netty.channel.PartialFlushException;
import io.netty.util.Signal;
import io.netty.util.internal.InternalLoggerFactory;
import io.netty.util.internal.TypeParameterMatcher;

public abstract class ChannelOutboundMessageHandlerAdapter<I>
extends ChannelOperationHandlerAdapter
implements ChannelOutboundMessageHandler<I> {
    protected static final Signal ABORT = new Signal(ChannelOutboundMessageHandlerAdapter.class.getName() + ".ABORT");
    private final TypeParameterMatcher msgMatcher = TypeParameterMatcher.find((Object)this, ChannelOutboundMessageHandlerAdapter.class, (String)"I");
    private boolean closeOnFailedFlush = true;

    protected ChannelOutboundMessageHandlerAdapter() {
    }

    protected final boolean isCloseOnFailedFlush() {
        return this.closeOnFailedFlush;
    }

    protected final void setCloseOnFailedFlush(boolean closeOnFailedFlush) {
        this.closeOnFailedFlush = closeOnFailedFlush;
    }

    @Override
    public MessageBuf<I> newOutboundBuffer(ChannelHandlerContext ctx) throws Exception {
        return Unpooled.messageBuffer();
    }

    @Override
    public void freeOutboundBuffer(ChannelHandlerContext ctx) throws Exception {
        ctx.outboundMessageBuffer().release();
    }

    protected boolean acceptOutboundMessage(Object msg) throws Exception {
        return this.msgMatcher.match(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void flush(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        MessageBuf in = ctx.outboundMessageBuffer();
        MessageBuf<Object> out = null;
        int inSize = in.size();
        if (inSize == 0) {
            ctx.flush(promise);
            return;
        }
        int processed = 0;
        try {
            Object msg;
            this.beginFlush(ctx);
            while ((msg = in.poll()) != null) {
                if (!this.acceptOutboundMessage(msg)) {
                    if (out == null) {
                        out = ctx.nextOutboundMessageBuffer();
                    }
                    out.add(msg);
                    ++processed;
                    continue;
                }
                Object imsg = msg;
                try {
                    this.flush(ctx, imsg);
                    ++processed;
                }
                finally {
                    BufUtil.release((Object)imsg);
                }
            }
        }
        catch (Throwable t) {
            PartialFlushException pfe;
            String msg = processed + " out of " + inSize + " message(s) flushed";
            if (t instanceof Signal) {
                Signal abort = (Signal)t;
                abort.expect(ABORT);
                pfe = new PartialFlushException("aborted by " + this.getClass().getSimpleName() + ": " + msg);
            } else {
                pfe = new PartialFlushException(msg, t);
            }
            this.fail(ctx, promise, pfe);
        }
        try {
            this.endFlush(ctx);
        }
        catch (Throwable t) {
            if (promise.isDone()) {
                InternalLoggerFactory.getInstance(this.getClass()).warn("endFlush() raised a masked exception due to failed flush().", t);
            }
            this.fail(ctx, promise, t);
        }
        if (!promise.isDone()) {
            ctx.flush(promise);
        }
    }

    private void fail(ChannelHandlerContext ctx, ChannelPromise promise, Throwable cause) {
        promise.setFailure(cause);
        if (this.isCloseOnFailedFlush()) {
            ctx.close();
        }
    }

    protected void beginFlush(ChannelHandlerContext ctx) throws Exception {
    }

    protected abstract void flush(ChannelHandlerContext var1, I var2) throws Exception;

    protected void endFlush(ChannelHandlerContext ctx) throws Exception {
    }
}

