/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelPromise;
import java.util.HashSet;
import java.util.Set;

public final class ChannelPromiseAggregator
implements ChannelFutureListener {
    private final ChannelPromise aggregatePromise;
    private Set<ChannelPromise> pendingPromises;

    public ChannelPromiseAggregator(ChannelPromise aggregatePromise) {
        this.aggregatePromise = aggregatePromise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelPromiseAggregator add(ChannelPromise ... promises) {
        if (promises == null) {
            throw new NullPointerException("promises");
        }
        ChannelPromiseAggregator channelPromiseAggregator = this;
        synchronized (channelPromiseAggregator) {
            if (this.pendingPromises == null) {
                this.pendingPromises = new HashSet<ChannelPromise>();
            }
            for (ChannelPromise p : promises) {
                if (p == null) continue;
                this.pendingPromises.add(p);
                p.addListener(this);
            }
        }
        return this;
    }

    @Override
    public synchronized void operationComplete(ChannelFuture future) throws Exception {
        if (this.pendingPromises == null) {
            this.aggregatePromise.setSuccess();
        } else {
            this.pendingPromises.remove(future);
            if (!future.isSuccess()) {
                this.aggregatePromise.setFailure(future.cause());
                for (ChannelPromise pendingFuture : this.pendingPromises) {
                    pendingFuture.setFailure(future.cause());
                }
            } else if (this.pendingPromises.isEmpty()) {
                this.aggregatePromise.setSuccess();
            }
        }
    }
}

