/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.buffer.BufType;
import io.netty.buffer.BufUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.MessageBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.IncompleteFlushException;
import io.netty.util.Signal;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;

public final class ChannelHandlerUtil {
    public static final Signal ABORT = new Signal(ChannelHandlerUtil.class.getName() + ".ABORT");
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ChannelHandlerUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static <T> void handleInboundBufferUpdated(ChannelHandlerContext ctx, SingleInboundMessageHandler<T> handler) throws Exception {
        block13: {
            in = ctx.inboundMessageBuffer();
            if (in.isEmpty() || !handler.beginMessageReceived(ctx)) {
                return;
            }
            out = ctx.nextInboundMessageBuffer();
            oldOutSize = out.size();
            try {
                while (true) lbl-1000:
                // 4 sources

                {
                    if ((msg = in.poll()) == null) {
                        break block13;
                    }
                    if (!handler.acceptInboundMessage(msg)) {
                        out.add(msg);
                        continue;
                    }
                    imsg = msg;
                    try {
                        handler.messageReceived(ctx, imsg);
                    }
                    finally {
                        BufUtil.release((Object)imsg);
                        continue;
                    }
                    break;
                }
            }
            catch (Signal abort) {
                abort.expect(ChannelHandlerUtil.ABORT);
                break block13;
            }
            finally {
                if (oldOutSize != out.size()) {
                    ctx.fireInboundBufferUpdated();
                }
                handler.endMessageReceived(ctx);
            }
            ** GOTO lbl-1000
        }
    }

    public static <T> void handleFlush(ChannelHandlerContext ctx, ChannelPromise promise, SingleOutboundMessageHandler<T> handler) throws Exception {
        ChannelHandlerUtil.handleFlush(ctx, promise, true, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void handleFlush(ChannelHandlerContext ctx, ChannelPromise promise, boolean closeOnFailedFlush, SingleOutboundMessageHandler<T> handler) throws Exception {
        MessageBuf in = ctx.outboundMessageBuffer();
        int inSize = in.size();
        if (inSize == 0) {
            ctx.flush(promise);
            return;
        }
        int processed = 0;
        try {
            Object msg;
            if (!handler.beginFlush(ctx)) {
                throw new IncompleteFlushException("beginFlush(..) rejected the flush request by returning false. none of " + inSize + " message(s) fulshed.");
            }
            while ((msg = in.poll()) != null) {
                if (!handler.acceptOutboundMessage(msg)) {
                    ChannelHandlerUtil.addToNextOutboundBuffer(ctx, msg);
                    ++processed;
                    continue;
                }
                Object imsg = msg;
                try {
                    handler.flush(ctx, imsg);
                    ++processed;
                }
                finally {
                    BufUtil.release((Object)imsg);
                }
            }
        }
        catch (Throwable t) {
            IncompleteFlushException pfe;
            if (t instanceof IncompleteFlushException) {
                pfe = (IncompleteFlushException)t;
            } else {
                String msg = processed + " out of " + inSize + " message(s) flushed";
                if (t instanceof Signal) {
                    Signal abort = (Signal)t;
                    abort.expect(ABORT);
                    pfe = new IncompleteFlushException("aborted: " + msg);
                } else {
                    pfe = new IncompleteFlushException(msg, t);
                }
            }
            ChannelHandlerUtil.fail(ctx, promise, closeOnFailedFlush, pfe);
        }
        try {
            handler.endFlush(ctx);
        }
        catch (Throwable t) {
            if (promise.isDone()) {
                logger.warn("endFlush() raised a masked exception due to failed flush().", t);
            }
            ChannelHandlerUtil.fail(ctx, promise, closeOnFailedFlush, t);
        }
        if (!promise.isDone()) {
            ctx.flush(promise);
        }
    }

    private static void fail(ChannelHandlerContext ctx, ChannelPromise promise, boolean closeOnFailedFlush, Throwable cause) {
        promise.setFailure(cause);
        if (closeOnFailedFlush) {
            ctx.close();
        }
    }

    public static ByteBuf allocate(ChannelHandlerContext ctx) {
        switch (ctx.channel().config().getDefaultHandlerByteBufType()) {
            case DIRECT: {
                return ctx.alloc().directBuffer();
            }
            case PREFER_DIRECT: {
                return ctx.alloc().ioBuffer();
            }
            case HEAP: {
                return ctx.alloc().heapBuffer();
            }
        }
        throw new IllegalStateException();
    }

    public static ByteBuf allocate(ChannelHandlerContext ctx, int initialCapacity) {
        switch (ctx.channel().config().getDefaultHandlerByteBufType()) {
            case DIRECT: {
                return ctx.alloc().directBuffer(initialCapacity);
            }
            case PREFER_DIRECT: {
                return ctx.alloc().ioBuffer(initialCapacity);
            }
            case HEAP: {
                return ctx.alloc().heapBuffer(initialCapacity);
            }
        }
        throw new IllegalStateException();
    }

    public static ByteBuf allocate(ChannelHandlerContext ctx, int initialCapacity, int maxCapacity) {
        switch (ctx.channel().config().getDefaultHandlerByteBufType()) {
            case DIRECT: {
                return ctx.alloc().directBuffer(initialCapacity, maxCapacity);
            }
            case PREFER_DIRECT: {
                return ctx.alloc().ioBuffer(initialCapacity, maxCapacity);
            }
            case HEAP: {
                return ctx.alloc().heapBuffer(initialCapacity, maxCapacity);
            }
        }
        throw new IllegalStateException();
    }

    public static boolean addToNextOutboundBuffer(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof ByteBuf && ctx.nextOutboundBufferType() == BufType.BYTE) {
            ctx.nextOutboundByteBuffer().writeBytes((ByteBuf)msg);
            return true;
        }
        return ctx.nextOutboundMessageBuffer().add(msg);
    }

    public static boolean addToNextInboundBuffer(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof ByteBuf && ctx.nextInboundBufferType() == BufType.BYTE) {
            ctx.nextInboundByteBuffer().writeBytes((ByteBuf)msg);
            return true;
        }
        return ctx.nextInboundMessageBuffer().add(msg);
    }

    private ChannelHandlerUtil() {
    }

    public static interface SingleOutboundMessageHandler<T> {
        public boolean acceptOutboundMessage(Object var1) throws Exception;

        public boolean beginFlush(ChannelHandlerContext var1) throws Exception;

        public void flush(ChannelHandlerContext var1, T var2) throws Exception;

        public void endFlush(ChannelHandlerContext var1) throws Exception;
    }

    public static interface SingleInboundMessageHandler<T> {
        public boolean acceptInboundMessage(Object var1) throws Exception;

        public boolean beginMessageReceived(ChannelHandlerContext var1) throws Exception;

        public void messageReceived(ChannelHandlerContext var1, T var2) throws Exception;

        public void endMessageReceived(ChannelHandlerContext var1) throws Exception;
    }
}

