/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.nio;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelProgressivePromise;
import io.netty.channel.ChannelPromise;
import io.netty.channel.FileRegion;
import io.netty.channel.nio.AbstractNioChannel;
import io.netty.channel.nio.NioTask;
import io.netty.channel.socket.ChannelInputShutdownEvent;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.WritableByteChannel;

public abstract class AbstractNioByteChannel
extends AbstractNioChannel {
    protected AbstractNioByteChannel(Channel parent, Integer id, SelectableChannel ch) {
        super(parent, id, ch, 1);
    }

    @Override
    protected AbstractNioChannel.AbstractNioUnsafe newUnsafe() {
        return new NioByteUnsafe();
    }

    @Override
    protected void doFlushByteBuffer(ByteBuf buf) throws Exception {
        int localFlushedAmount;
        for (int i = this.config().getWriteSpinCount() - 1; i >= 0 && (localFlushedAmount = this.doWriteBytes(buf, i == 0)) <= 0; --i) {
            if (buf.isReadable()) continue;
            buf.clear();
            break;
        }
    }

    @Override
    protected void doFlushFileRegion(FileRegion region, ChannelPromise promise) throws Exception {
        if (!(this.javaChannel() instanceof WritableByteChannel)) {
            throw new UnsupportedOperationException("Underlying Channel is not of instance " + WritableByteChannel.class);
        }
        TransferTask transferTask = new TransferTask(region, (WritableByteChannel)((Object)this.javaChannel()), promise);
        transferTask.transfer();
    }

    protected abstract int doReadBytes(ByteBuf var1) throws Exception;

    protected abstract int doWriteBytes(ByteBuf var1, boolean var2) throws Exception;

    private final class TransferTask
    implements NioTask<SelectableChannel> {
        private long writtenBytes;
        private final FileRegion region;
        private final WritableByteChannel wch;
        private final ChannelPromise promise;

        TransferTask(FileRegion region, WritableByteChannel wch, ChannelPromise promise) {
            this.region = region;
            this.wch = wch;
            this.promise = promise;
        }

        void transfer() {
            try {
                do {
                    long localWrittenBytes;
                    if ((localWrittenBytes = this.region.transferTo(this.wch, this.writtenBytes)) == 0L) {
                        AbstractNioByteChannel.this.eventLoop().executeWhenWritable(AbstractNioByteChannel.this, this);
                        return;
                    }
                    if (localWrittenBytes == -1L) {
                        AbstractNioByteChannel.checkEOF(this.region, this.writtenBytes);
                        this.promise.setSuccess();
                        return;
                    }
                    this.writtenBytes += localWrittenBytes;
                    if (!(this.promise instanceof ChannelProgressivePromise)) continue;
                    ((ChannelProgressivePromise)this.promise).setProgress(this.writtenBytes, this.region.count());
                } while (this.writtenBytes < this.region.count());
                this.region.release();
                this.promise.setSuccess();
                return;
            }
            catch (Throwable cause) {
                this.region.release();
                this.promise.setFailure(cause);
                return;
            }
        }

        @Override
        public void channelReady(SelectableChannel ch, SelectionKey key) throws Exception {
            this.transfer();
        }

        @Override
        public void channelUnregistered(SelectableChannel ch, Throwable cause) throws Exception {
            if (cause != null) {
                this.promise.setFailure(cause);
                return;
            }
            if (this.writtenBytes < this.region.count()) {
                this.region.release();
                if (!AbstractNioByteChannel.this.isOpen()) {
                    this.promise.setFailure(new ClosedChannelException());
                } else {
                    this.promise.setFailure(new IllegalStateException("Channel was unregistered before the region could be fully written"));
                }
            }
        }
    }

    private final class NioByteUnsafe
    extends AbstractNioChannel.AbstractNioUnsafe {
        private NioByteUnsafe() {
            super(AbstractNioByteChannel.this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void read() {
            assert (AbstractNioByteChannel.this.eventLoop().inEventLoop());
            SelectionKey key = AbstractNioByteChannel.this.selectionKey();
            if (!AbstractNioByteChannel.this.config().isAutoRead()) {
                key.interestOps(key.interestOps() & ~AbstractNioByteChannel.this.readInterestOp);
            }
            ChannelPipeline pipeline = AbstractNioByteChannel.this.pipeline();
            ByteBuf byteBuf = pipeline.inboundByteBuffer();
            boolean closed = false;
            boolean read = false;
            boolean firedChannelReadSuspended = false;
            try {
                AbstractNioByteChannel.expandReadBuffer(byteBuf);
                while (true) {
                    int localReadAmount;
                    if ((localReadAmount = AbstractNioByteChannel.this.doReadBytes(byteBuf)) > 0) {
                        read = true;
                    } else if (localReadAmount < 0) {
                        closed = true;
                        return;
                    }
                    switch (AbstractNioByteChannel.expandReadBuffer(byteBuf)) {
                        case 0: {
                            return;
                        }
                        case 1: {
                            break;
                        }
                        case 2: {
                            if (!read) break;
                            read = false;
                            pipeline.fireInboundBufferUpdated();
                            if (byteBuf.isWritable()) break;
                            throw new IllegalStateException("an inbound handler whose buffer is full must consume at least one byte.");
                        }
                    }
                }
            }
            catch (Throwable t) {
                if (read) {
                    read = false;
                    pipeline.fireInboundBufferUpdated();
                }
                if (t instanceof IOException) {
                    closed = true;
                } else if (!closed) {
                    firedChannelReadSuspended = true;
                    pipeline.fireChannelReadSuspended();
                }
                AbstractNioByteChannel.this.pipeline().fireExceptionCaught(t);
                return;
            }
            finally {
                if (read) {
                    pipeline.fireInboundBufferUpdated();
                }
                if (closed) {
                    AbstractNioByteChannel.this.setInputShutdown();
                    if (AbstractNioByteChannel.this.isOpen()) {
                        if (Boolean.TRUE.equals(AbstractNioByteChannel.this.config().getOption(ChannelOption.ALLOW_HALF_CLOSURE))) {
                            key.interestOps(key.interestOps() & ~AbstractNioByteChannel.this.readInterestOp);
                            pipeline.fireUserEventTriggered(ChannelInputShutdownEvent.INSTANCE);
                        } else {
                            this.close(this.voidFuture());
                        }
                    }
                } else if (!firedChannelReadSuspended) {
                    pipeline.fireChannelReadSuspended();
                }
            }
        }
    }
}

