/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.MessageList;
import io.netty.util.internal.TypeParameterMatcher;

public abstract class SimpleChannelInboundHandler<I>
extends ChannelInboundHandlerAdapter {
    private static final Object UNRELEASABLE = new Object();
    private final TypeParameterMatcher matcher;
    private final boolean autoRelease;

    protected SimpleChannelInboundHandler() {
        this(true);
    }

    protected SimpleChannelInboundHandler(boolean autoRelease) {
        this.matcher = TypeParameterMatcher.find((Object)this, SimpleChannelInboundHandler.class, (String)"I");
        this.autoRelease = autoRelease;
    }

    protected SimpleChannelInboundHandler(Class<? extends I> inboundMessageType) {
        this(inboundMessageType, true);
    }

    protected SimpleChannelInboundHandler(Class<? extends I> inboundMessageType, boolean autoRelease) {
        this.matcher = TypeParameterMatcher.get(inboundMessageType);
        this.autoRelease = autoRelease;
    }

    public boolean acceptInboundMessage(Object msg) throws Exception {
        return this.matcher.match(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageList<Object> msgs) throws Exception {
        MessageList<Object> unaccepted = MessageList.newInstance();
        int size = msgs.size();
        try {
            this.beginMessageReceived(ctx);
            for (int i = 0; i < size; ++i) {
                Object msg = msgs.get(i);
                if (!ctx.isRemoved() && this.acceptInboundMessage(msg)) {
                    if (!unaccepted.isEmpty()) {
                        ctx.fireMessageReceived(unaccepted);
                        unaccepted = MessageList.newInstance();
                    }
                    Object imsg = msg;
                    this.messageReceived(ctx, imsg);
                    continue;
                }
                if (this.autoRelease) {
                    msgs.set(i, UNRELEASABLE);
                }
                unaccepted.add(msg);
            }
        }
        finally {
            try {
                if (this.autoRelease) {
                    msgs.releaseAllAndRecycle();
                } else {
                    msgs.recycle();
                }
            }
            finally {
                try {
                    this.endMessageReceived(ctx);
                }
                finally {
                    ctx.fireMessageReceived(unaccepted);
                }
            }
        }
    }

    protected abstract void messageReceived(ChannelHandlerContext var1, I var2) throws Exception;

    protected void beginMessageReceived(ChannelHandlerContext ctx) throws Exception {
    }

    protected void endMessageReceived(ChannelHandlerContext ctx) throws Exception {
    }
}

