/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.ant.install;

public class UnixPermissions {
    private static final int PERM_MASK = 4095;
    private static final int S_IRUSR = 256;
    private static final int S_IWUSR = 128;
    private static final int S_IXUSR = 64;
    private static final int S_IRGRP = 32;
    private static final int S_IWGRP = 16;
    private static final int S_IXGRP = 8;
    private static final int S_IROTH = 4;
    private static final int S_IWOTH = 2;
    private static final int S_IXOTH = 1;
    private int permission;

    public UnixPermissions(int permission) {
        this.permission = permission & 0xFFF;
    }

    public boolean isOwnerRead() {
        return UnixPermissions.isPermissionEnabled(this.permission, 256);
    }

    public boolean isOwnerWrite() {
        return UnixPermissions.isPermissionEnabled(this.permission, 128);
    }

    public boolean isOwnerExecute() {
        return UnixPermissions.isPermissionEnabled(this.permission, 64);
    }

    public boolean isGroupRead() {
        return UnixPermissions.isPermissionEnabled(this.permission, 32);
    }

    public boolean isGroupWrite() {
        return UnixPermissions.isPermissionEnabled(this.permission, 16);
    }

    public boolean isGroupExecute() {
        return UnixPermissions.isPermissionEnabled(this.permission, 8);
    }

    public boolean isOtherRead() {
        return UnixPermissions.isPermissionEnabled(this.permission, 4);
    }

    public boolean isOtherWrite() {
        return UnixPermissions.isPermissionEnabled(this.permission, 2);
    }

    public boolean isOtherExecute() {
        return UnixPermissions.isPermissionEnabled(this.permission, 1);
    }

    private static boolean isPermissionEnabled(int permission, int mask) {
        return (permission & mask) == mask;
    }
}

