/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.autoconfigure.internal;

import io.opentelemetry.sdk.autoconfigure.internal.NamedSpiManager;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.Ordered;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.ServiceLoader;
import java.util.function.BiFunction;
import java.util.function.Function;

public final class SpiHelper {
    private final ClassLoader classLoader;
    private final SpiFinder spiFinder;

    SpiHelper(ClassLoader classLoader, SpiFinder spiFinder) {
        this.classLoader = classLoader;
        this.spiFinder = spiFinder;
    }

    public static SpiHelper create(ClassLoader classLoader) {
        return new SpiHelper(classLoader, ServiceLoader::load);
    }

    public <T, S> NamedSpiManager<T> loadConfigurable(Class<S> spiClass, Function<S, String> getName, BiFunction<S, ConfigProperties, T> getConfigurable, ConfigProperties config) {
        HashMap nameToProvider = new HashMap();
        for (Object provider : this.load(spiClass)) {
            String name = getName.apply(provider);
            nameToProvider.put(name, () -> getConfigurable.apply(provider, config));
        }
        return NamedSpiManager.create(nameToProvider);
    }

    public <T extends Ordered> List<T> loadOrdered(Class<T> spiClass) {
        List<T> result = this.load(spiClass);
        result.sort(Comparator.comparing(Ordered::order));
        return result;
    }

    public <T> List<T> load(Class<T> spiClass) {
        ArrayList<T> result = new ArrayList<T>();
        for (T service : this.spiFinder.load(spiClass, this.classLoader)) {
            result.add(service);
        }
        return result;
    }

    static interface SpiFinder {
        public <T> Iterable<T> load(Class<T> var1, ClassLoader var2);
    }
}

