/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.incubator.fileconfig;

import io.opentelemetry.sdk.autoconfigure.internal.NamedSpiManager;
import io.opentelemetry.sdk.autoconfigure.internal.SpiHelper;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import io.opentelemetry.sdk.autoconfigure.spi.internal.DefaultConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.logs.ConfigurableLogRecordExporterProvider;
import io.opentelemetry.sdk.extension.incubator.fileconfig.Factory;
import io.opentelemetry.sdk.extension.incubator.fileconfig.FileConfigUtil;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.LogRecordExporter;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.Otlp;
import java.io.Closeable;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

final class LogRecordExporterFactory
implements Factory<LogRecordExporter, io.opentelemetry.sdk.logs.export.LogRecordExporter> {
    private static final LogRecordExporterFactory INSTANCE = new LogRecordExporterFactory();

    private LogRecordExporterFactory() {
    }

    static LogRecordExporterFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public io.opentelemetry.sdk.logs.export.LogRecordExporter create(@Nullable LogRecordExporter model, SpiHelper spiHelper, List<Closeable> closeables) {
        if (model == null) {
            return io.opentelemetry.sdk.logs.export.LogRecordExporter.composite((io.opentelemetry.sdk.logs.export.LogRecordExporter[])new io.opentelemetry.sdk.logs.export.LogRecordExporter[0]);
        }
        Otlp otlpModel = model.getOtlp();
        if (otlpModel != null) {
            return FileConfigUtil.addAndReturn(closeables, LogRecordExporterFactory.createOtlpExporter(otlpModel, spiHelper));
        }
        if (!model.getAdditionalProperties().isEmpty()) {
            throw new ConfigurationException("Unrecognized log record exporter(s): " + model.getAdditionalProperties().keySet().stream().collect(Collectors.joining(",", "[", "]")));
        }
        return io.opentelemetry.sdk.logs.export.LogRecordExporter.composite((io.opentelemetry.sdk.logs.export.LogRecordExporter[])new io.opentelemetry.sdk.logs.export.LogRecordExporter[0]);
    }

    private static io.opentelemetry.sdk.logs.export.LogRecordExporter createOtlpExporter(Otlp otlp, SpiHelper spiHelper) {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (otlp.getProtocol() != null) {
            properties.put("otel.exporter.otlp.logs.protocol", otlp.getProtocol());
        }
        if (otlp.getEndpoint() != null) {
            properties.put("otel.exporter.otlp.endpoint", otlp.getEndpoint());
        }
        if (otlp.getHeaders() != null) {
            properties.put("otel.exporter.otlp.logs.headers", otlp.getHeaders().getAdditionalProperties().entrySet().stream().map(entry -> (String)entry.getKey() + "=" + entry.getValue()).collect(Collectors.joining(",")));
        }
        if (otlp.getCompression() != null) {
            properties.put("otel.exporter.otlp.logs.compression", otlp.getCompression());
        }
        if (otlp.getTimeout() != null) {
            properties.put("otel.exporter.otlp.logs.timeout", Integer.toString(otlp.getTimeout()));
        }
        if (otlp.getCertificate() != null) {
            properties.put("otel.exporter.otlp.logs.certificate", otlp.getCertificate());
        }
        if (otlp.getClientKey() != null) {
            properties.put("otel.exporter.otlp.logs.client.key", otlp.getClientKey());
        }
        if (otlp.getClientCertificate() != null) {
            properties.put("otel.exporter.otlp.logs.client.certificate", otlp.getClientCertificate());
        }
        DefaultConfigProperties configProperties = DefaultConfigProperties.createFromMap(properties);
        return FileConfigUtil.assertNotNull((io.opentelemetry.sdk.logs.export.LogRecordExporter)LogRecordExporterFactory.logRecordExporterSpiManager((ConfigProperties)configProperties, spiHelper).getByName("otlp"), "otlp exporter");
    }

    private static NamedSpiManager<io.opentelemetry.sdk.logs.export.LogRecordExporter> logRecordExporterSpiManager(ConfigProperties config, SpiHelper spiHelper) {
        return spiHelper.loadConfigurable(ConfigurableLogRecordExporterProvider.class, ConfigurableLogRecordExporterProvider::getName, ConfigurableLogRecordExporterProvider::createExporter, config);
    }
}

