/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.incubator.fileconfig;

import io.opentelemetry.sdk.autoconfigure.internal.NamedSpiManager;
import io.opentelemetry.sdk.autoconfigure.internal.SpiHelper;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import io.opentelemetry.sdk.autoconfigure.spi.internal.DefaultConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.metrics.ConfigurableMetricExporterProvider;
import io.opentelemetry.sdk.extension.incubator.fileconfig.Factory;
import io.opentelemetry.sdk.extension.incubator.fileconfig.FileConfigUtil;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.MetricExporter;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.OtlpMetric;
import java.io.Closeable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

final class MetricExporterFactory
implements Factory<MetricExporter, io.opentelemetry.sdk.metrics.export.MetricExporter> {
    private static final MetricExporterFactory INSTANCE = new MetricExporterFactory();

    private MetricExporterFactory() {
    }

    static MetricExporterFactory getInstance() {
        return INSTANCE;
    }

    @Override
    @Nullable
    public io.opentelemetry.sdk.metrics.export.MetricExporter create(@Nullable MetricExporter model, SpiHelper spiHelper, List<Closeable> closeables) {
        if (model == null) {
            return null;
        }
        OtlpMetric otlpModel = model.getOtlp();
        if (otlpModel != null) {
            return FileConfigUtil.addAndReturn(closeables, MetricExporterFactory.createOtlpExporter(otlpModel, spiHelper));
        }
        if (model.getConsole() != null) {
            return FileConfigUtil.addAndReturn(closeables, MetricExporterFactory.createConsoleExporter(spiHelper));
        }
        if (model.getPrometheus() != null) {
            throw new ConfigurationException("prometheus exporter not supported in this context");
        }
        if (!model.getAdditionalProperties().isEmpty()) {
            throw new ConfigurationException("Unrecognized metric exporter(s): " + model.getAdditionalProperties().keySet().stream().collect(Collectors.joining(",", "[", "]")));
        }
        return null;
    }

    private static io.opentelemetry.sdk.metrics.export.MetricExporter createOtlpExporter(OtlpMetric model, SpiHelper spiHelper) {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (model.getProtocol() != null) {
            properties.put("otel.exporter.otlp.metrics.protocol", model.getProtocol());
        }
        if (model.getEndpoint() != null) {
            properties.put("otel.exporter.otlp.endpoint", model.getEndpoint());
        }
        if (model.getHeaders() != null) {
            properties.put("otel.exporter.otlp.metrics.headers", model.getHeaders().getAdditionalProperties().entrySet().stream().map(entry -> (String)entry.getKey() + "=" + entry.getValue()).collect(Collectors.joining(",")));
        }
        if (model.getCompression() != null) {
            properties.put("otel.exporter.otlp.metrics.compression", model.getCompression());
        }
        if (model.getTimeout() != null) {
            properties.put("otel.exporter.otlp.metrics.timeout", Integer.toString(model.getTimeout()));
        }
        if (model.getCertificate() != null) {
            properties.put("otel.exporter.otlp.metrics.certificate", model.getCertificate());
        }
        if (model.getClientKey() != null) {
            properties.put("otel.exporter.otlp.metrics.client.key", model.getClientKey());
        }
        if (model.getClientCertificate() != null) {
            properties.put("otel.exporter.otlp.metrics.client.certificate", model.getClientCertificate());
        }
        if (model.getDefaultHistogramAggregation() != null) {
            properties.put("otel.exporter.otlp.metrics.default.histogram.aggregation", model.getDefaultHistogramAggregation().value());
        }
        if (model.getTemporalityPreference() != null) {
            properties.put("otel.exporter.otlp.metrics.temporality.preference", model.getTemporalityPreference());
        }
        DefaultConfigProperties configProperties = DefaultConfigProperties.createFromMap(properties);
        return FileConfigUtil.assertNotNull((io.opentelemetry.sdk.metrics.export.MetricExporter)MetricExporterFactory.metricExporterSpiManager((ConfigProperties)configProperties, spiHelper).getByName("otlp"), "otlp exporter");
    }

    private static io.opentelemetry.sdk.metrics.export.MetricExporter createConsoleExporter(SpiHelper spiHelper) {
        return FileConfigUtil.assertNotNull((io.opentelemetry.sdk.metrics.export.MetricExporter)MetricExporterFactory.metricExporterSpiManager((ConfigProperties)DefaultConfigProperties.createFromMap(Collections.emptyMap()), spiHelper).getByName("logging"), "logging exporter");
    }

    private static NamedSpiManager<io.opentelemetry.sdk.metrics.export.MetricExporter> metricExporterSpiManager(ConfigProperties config, SpiHelper spiHelper) {
        return spiHelper.loadConfigurable(ConfigurableMetricExporterProvider.class, ConfigurableMetricExporterProvider::getName, ConfigurableMetricExporterProvider::createExporter, config);
    }
}

