/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.aggregator;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.common.export.MemoryMode;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.LongExemplarData;
import io.opentelemetry.sdk.metrics.data.LongPointData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorHandle;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableGaugeData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableLongPointData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableMetricData;
import io.opentelemetry.sdk.metrics.internal.data.MutableLongPointData;
import io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarReservoirFactory;
import io.opentelemetry.sdk.resources.Resource;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;

public final class LongLastValueAggregator
implements Aggregator<LongPointData> {
    private final ExemplarReservoirFactory reservoirFactory;
    private final MemoryMode memoryMode;

    public LongLastValueAggregator(ExemplarReservoirFactory reservoirFactory, MemoryMode memoryMode) {
        this.reservoirFactory = reservoirFactory;
        this.memoryMode = memoryMode;
    }

    @Override
    public AggregatorHandle<LongPointData> createHandle() {
        return new Handle(this.reservoirFactory, this.memoryMode);
    }

    @Override
    public LongPointData diff(LongPointData previous, LongPointData current) {
        return current;
    }

    @Override
    public void diffInPlace(LongPointData previousReusablePoint, LongPointData currentPoint) {
        ((MutableLongPointData)previousReusablePoint).set(currentPoint);
    }

    @Override
    public LongPointData createReusablePoint() {
        return new MutableLongPointData();
    }

    @Override
    public void copyPoint(LongPointData point, LongPointData toReusablePoint) {
        ((MutableLongPointData)toReusablePoint).set(point);
    }

    @Override
    public MetricData toMetricData(Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, MetricDescriptor descriptor, Collection<LongPointData> points, AggregationTemporality temporality) {
        return ImmutableMetricData.createLongGauge(resource, instrumentationScopeInfo, descriptor.getName(), descriptor.getDescription(), descriptor.getSourceInstrument().getUnit(), ImmutableGaugeData.create(points));
    }

    static final class Handle
    extends AggregatorHandle<LongPointData> {
        @Nullable
        private static final Long DEFAULT_VALUE = null;
        private final AtomicReference<Long> current = new AtomicReference<Long>(DEFAULT_VALUE);
        @Nullable
        private final MutableLongPointData reusablePoint;

        Handle(ExemplarReservoirFactory reservoirFactory, MemoryMode memoryMode) {
            super(reservoirFactory, false);
            this.reusablePoint = memoryMode == MemoryMode.REUSABLE_DATA ? new MutableLongPointData() : null;
        }

        @Override
        protected LongPointData doAggregateThenMaybeResetLongs(long startEpochNanos, long epochNanos, Attributes attributes, List<LongExemplarData> exemplars, boolean reset) {
            Long value;
            Long l = value = reset ? this.current.getAndSet(DEFAULT_VALUE) : this.current.get();
            if (this.reusablePoint != null) {
                this.reusablePoint.set(startEpochNanos, epochNanos, attributes, Objects.requireNonNull(value), exemplars);
                return this.reusablePoint;
            }
            return ImmutableLongPointData.create(startEpochNanos, epochNanos, attributes, Objects.requireNonNull(value), exemplars);
        }

        @Override
        protected void doRecordLong(long value) {
            this.current.set(value);
        }
    }
}

