/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.jdbc.parser;

import io.opentracing.contrib.jdbc.ConnectionInfo;
import io.opentracing.contrib.jdbc.parser.AbstractURLParser;
import io.opentracing.contrib.jdbc.parser.URLLocation;

public class MysqlURLParser
extends AbstractURLParser {
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 3306;

    protected String dbType() {
        return "mysql";
    }

    @Override
    protected URLLocation fetchDatabaseHostsIndexRange(String url) {
        int hostLabelStartIndex = url.indexOf("//") + 2;
        int hostLabelEndIndex = url.indexOf("/", hostLabelStartIndex);
        if (hostLabelEndIndex == -1) {
            int queryStringStartIndex = url.indexOf("?", hostLabelStartIndex);
            hostLabelEndIndex = queryStringStartIndex == -1 ? url.length() : queryStringStartIndex;
        }
        return new URLLocation(hostLabelStartIndex, hostLabelEndIndex);
    }

    protected String fetchDatabaseNameFromURL(String url, int startSize) {
        URLLocation hostsLocation = this.fetchDatabaseNameIndexRange(url, startSize);
        if (hostsLocation == null) {
            return "";
        }
        return url.substring(hostsLocation.startIndex(), hostsLocation.endIndex());
    }

    protected URLLocation fetchDatabaseNameIndexRange(String url, int startSize) {
        int databaseStartTag = url.indexOf("/", startSize);
        if (databaseStartTag == -1) {
            return null;
        }
        int databaseEndTag = url.indexOf("?", databaseStartTag);
        if (databaseEndTag == -1) {
            databaseEndTag = url.length();
        }
        return new URLLocation(databaseStartTag + 1, databaseEndTag);
    }

    @Override
    protected URLLocation fetchDatabaseNameIndexRange(String url) {
        int databaseStartTag = url.lastIndexOf("/");
        int databaseEndTag = url.indexOf("?", databaseStartTag);
        if (databaseEndTag == -1) {
            databaseEndTag = url.length();
        }
        return new URLLocation(databaseStartTag + 1, databaseEndTag);
    }

    @Override
    public ConnectionInfo parse(String url) {
        String[] hostSegment;
        URLLocation location = this.fetchDatabaseHostsIndexRange(url);
        String hosts = url.substring(location.startIndex(), location.endIndex());
        if (hosts.isEmpty()) {
            hosts = DEFAULT_HOST;
        }
        if ((hostSegment = hosts.split(",")).length > 1) {
            StringBuilder sb = new StringBuilder();
            for (String host : hostSegment) {
                if (host.split(":").length == 1) {
                    sb.append(host + ":" + 3306 + ",");
                    continue;
                }
                sb.append(host + ",");
            }
            if (',' == sb.charAt(sb.length() - 1)) {
                sb.deleteCharAt(sb.length() - 1);
            }
            return new ConnectionInfo.Builder(sb.toString()).dbType(this.dbType()).dbInstance(this.fetchDatabaseNameFromURL(url)).build();
        }
        String[] hostAndPort = hostSegment[0].split(":");
        if (hostAndPort.length != 1) {
            return new ConnectionInfo.Builder(hostAndPort[0], Integer.valueOf(hostAndPort[1])).dbType(this.dbType()).dbInstance(this.fetchDatabaseNameFromURL(url, location.endIndex())).build();
        }
        return new ConnectionInfo.Builder(hostAndPort[0], 3306).dbType(this.dbType()).dbInstance(this.fetchDatabaseNameFromURL(url, location.endIndex())).build();
    }
}

