/*
 * Decompiled with CFR 0.152.
 */
package reactor.adapter.rxjava;

import io.reactivex.BackpressureStrategy;
import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.Maybe;
import io.reactivex.MaybeObserver;
import io.reactivex.Observable;
import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.fuseable.ConditionalSubscriber;
import io.reactivex.internal.fuseable.QueueSubscription;
import io.reactivex.internal.operators.completable.CompletableFromPublisher;
import io.reactivex.internal.operators.single.SingleFromPublisher;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Exceptions;
import reactor.core.Fuseable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;

public abstract class RxJava2Adapter {
    public static <T> Flux<T> flowableToFlux(Flowable<T> source) {
        return new FlowableAsFlux<T>(source);
    }

    public static <T> Flowable<T> fluxToFlowable(Flux<T> source) {
        return new FluxAsFlowable<T>(source);
    }

    public static <T> Flowable<T> monoToFlowable(Mono<T> source) {
        return new FluxAsFlowable<T>(source);
    }

    public static Completable monoToCompletable(Mono<?> source) {
        return new CompletableFromPublisher(source);
    }

    public static Mono<Void> completableToMono(Completable source) {
        return new CompletableAsMono(source);
    }

    public static <T> Single<T> monoToSingle(Mono<T> source) {
        return new SingleFromPublisher(source);
    }

    public static <T> Mono<T> singleToMono(Single<T> source) {
        return new SingleAsMono<T>(source);
    }

    public static <T> Flux<T> observableToFlux(Observable<T> source, BackpressureStrategy strategy) {
        return RxJava2Adapter.flowableToFlux(source.toFlowable(strategy));
    }

    public static <T> Observable<T> fluxToObservable(Flux<T> source) {
        return RxJava2Adapter.fluxToFlowable(source).toObservable();
    }

    public static <T> Mono<T> maybeToMono(Maybe<T> source) {
        return new MaybeAsMono<T>(source);
    }

    public static <T> Maybe<T> monoToMaybe(Mono<T> source) {
        return new MonoAsMaybe<T>(source);
    }

    RxJava2Adapter() {
    }

    static final class MaybeAsMono<T>
    extends Mono<T>
    implements Fuseable {
        final Maybe<T> source;

        public MaybeAsMono(Maybe<T> source) {
            this.source = source;
        }

        public void subscribe(CoreSubscriber<? super T> s) {
            this.source.subscribe(new MaybeAsMonoObserver<T>(s));
        }

        static final class MaybeAsMonoObserver<T>
        extends Operators.MonoSubscriber<T, T>
        implements MaybeObserver<T> {
            Disposable d;

            public MaybeAsMonoObserver(CoreSubscriber<? super T> subscriber) {
                super(subscriber);
            }

            public void onSubscribe(Disposable d) {
                this.d = d;
                this.actual.onSubscribe((Subscription)this);
            }

            public void onSuccess(T value) {
                this.complete(value);
            }

            public void cancel() {
                super.cancel();
                this.d.dispose();
            }
        }
    }

    static final class MonoAsMaybe<T>
    extends Maybe<T> {
        final Mono<T> source;

        public MonoAsMaybe(Mono<T> source) {
            this.source = source;
        }

        protected void subscribeActual(MaybeObserver<? super T> observer) {
            this.source.subscribe(new MonoSubscriber<T>(observer));
        }

        static final class MonoSubscriber<T>
        implements CoreSubscriber<T>,
        Disposable {
            final MaybeObserver<? super T> actual;
            Subscription s;

            public MonoSubscriber(MaybeObserver<? super T> actual) {
                this.actual = actual;
            }

            public void onSubscribe(Subscription s) {
                this.s = s;
                this.actual.onSubscribe((Disposable)this);
                s.request(Long.MAX_VALUE);
            }

            public void onNext(T t) {
                this.s = Operators.cancelledSubscription();
                this.actual.onSuccess(t);
            }

            public void onError(Throwable t) {
                this.s = Operators.cancelledSubscription();
                this.actual.onError(t);
            }

            public void onComplete() {
                if (this.s != Operators.cancelledSubscription()) {
                    this.s = Operators.cancelledSubscription();
                    this.actual.onComplete();
                }
            }

            public void dispose() {
                this.s.cancel();
                this.s = Operators.cancelledSubscription();
            }

            public boolean isDisposed() {
                return this.s == Operators.cancelledSubscription();
            }
        }
    }

    static final class SingleAsMono<T>
    extends Mono<T>
    implements Fuseable {
        final Single<T> source;

        public SingleAsMono(Single<T> source) {
            this.source = source;
        }

        public void subscribe(CoreSubscriber<? super T> s) {
            SingleAsMonoSubscriber<? super T> single = new SingleAsMonoSubscriber<T>(s);
            this.source.subscribe(single);
        }

        static final class SingleAsMonoSubscriber<T>
        extends Operators.MonoSubscriber<T, T>
        implements SingleObserver<T> {
            Disposable d;

            public SingleAsMonoSubscriber(CoreSubscriber<? super T> subscriber) {
                super(subscriber);
            }

            public void onSubscribe(Disposable d) {
                this.d = d;
                this.actual.onSubscribe((Subscription)this);
            }

            public void onSuccess(T value) {
                this.complete(value);
            }
        }
    }

    static final class CompletableAsMono
    extends Mono<Void>
    implements Fuseable {
        final Completable source;

        public CompletableAsMono(Completable source) {
            this.source = source;
        }

        public void subscribe(CoreSubscriber<? super Void> s) {
            this.source.subscribe((CompletableObserver)new CompletableAsMonoSubscriber((Subscriber<? super Void>)s));
        }

        static final class CompletableAsMonoSubscriber
        implements CompletableObserver,
        Fuseable.QueueSubscription<Void> {
            final Subscriber<? super Void> actual;
            Disposable d;

            public CompletableAsMonoSubscriber(Subscriber<? super Void> actual) {
                this.actual = actual;
            }

            public void onSubscribe(Disposable d) {
                this.d = d;
                this.actual.onSubscribe((Subscription)this);
            }

            public void onError(Throwable e) {
                this.actual.onError(e);
            }

            public void onComplete() {
                this.actual.onComplete();
            }

            public void request(long n) {
            }

            public void cancel() {
                this.d.dispose();
            }

            public boolean isEmpty() {
                return true;
            }

            public Void poll() {
                return null;
            }

            public int requestFusion(int requestedMode) {
                return requestedMode & 2;
            }

            public int size() {
                return 0;
            }

            public void clear() {
            }
        }
    }

    static final class FluxAsFlowable<T>
    extends Flowable<T> {
        final Publisher<T> source;

        public FluxAsFlowable(Publisher<T> source) {
            this.source = source;
        }

        public void subscribeActual(Subscriber<? super T> s) {
            if (s instanceof ConditionalSubscriber) {
                this.source.subscribe(new FluxAsFlowableConditionalSubscriber((ConditionalSubscriber)s));
            } else {
                this.source.subscribe(new FluxAsFlowableSubscriber<T>(s));
            }
        }

        static final class FluxAsFlowableConditionalSubscriber<T>
        implements Fuseable.ConditionalSubscriber<T>,
        QueueSubscription<T> {
            final ConditionalSubscriber<? super T> actual;
            Subscription s;
            QueueSubscription<T> qs;

            public FluxAsFlowableConditionalSubscriber(ConditionalSubscriber<? super T> actual) {
                this.actual = actual;
            }

            public void onSubscribe(Subscription s) {
                if (Operators.validate((Subscription)this.s, (Subscription)s)) {
                    this.s = s;
                    if (s instanceof QueueSubscription) {
                        this.qs = (QueueSubscription)s;
                    }
                    this.actual.onSubscribe((Subscription)this);
                }
            }

            public void onNext(T t) {
                this.actual.onNext(t);
            }

            public boolean tryOnNext(T t) {
                return this.actual.tryOnNext(t);
            }

            public void onError(Throwable t) {
                this.actual.onError(t);
            }

            public void onComplete() {
                this.actual.onComplete();
            }

            public void request(long n) {
                this.s.request(n);
            }

            public void cancel() {
                this.s.cancel();
            }

            public T poll() {
                try {
                    return (T)this.qs.poll();
                }
                catch (Throwable ex) {
                    throw Exceptions.bubble((Throwable)ex);
                }
            }

            public boolean isEmpty() {
                return this.qs.isEmpty();
            }

            public void clear() {
                this.qs.clear();
            }

            public int requestFusion(int requestedMode) {
                if (this.qs != null) {
                    return this.qs.requestFusion(requestedMode);
                }
                return 0;
            }

            public boolean offer(T v1) {
                throw new UnsupportedOperationException("Should not be called!");
            }

            public boolean offer(T v1, T v2) {
                throw new UnsupportedOperationException("Should not be called!");
            }
        }

        static final class FluxAsFlowableSubscriber<T>
        implements CoreSubscriber<T>,
        QueueSubscription<T> {
            final Subscriber<? super T> actual;
            Subscription s;
            Fuseable.QueueSubscription<T> qs;

            public FluxAsFlowableSubscriber(Subscriber<? super T> actual) {
                this.actual = actual;
            }

            public void onSubscribe(Subscription s) {
                if (Operators.validate((Subscription)this.s, (Subscription)s)) {
                    this.s = s;
                    if (s instanceof Fuseable.QueueSubscription) {
                        this.qs = (Fuseable.QueueSubscription)s;
                    }
                    this.actual.onSubscribe((Subscription)this);
                }
            }

            public void onNext(T t) {
                this.actual.onNext(t);
            }

            public void onError(Throwable t) {
                this.actual.onError(t);
            }

            public void onComplete() {
                this.actual.onComplete();
            }

            public void request(long n) {
                this.s.request(n);
            }

            public void cancel() {
                this.s.cancel();
            }

            public T poll() {
                return (T)this.qs.poll();
            }

            public boolean isEmpty() {
                return this.qs.isEmpty();
            }

            public void clear() {
                this.qs.clear();
            }

            public int requestFusion(int requestedMode) {
                if (this.qs != null) {
                    return this.qs.requestFusion(requestedMode);
                }
                return 0;
            }

            public boolean offer(T value) {
                throw new UnsupportedOperationException("Should not be called");
            }

            public boolean offer(T v1, T v2) {
                throw new UnsupportedOperationException("Should not be called");
            }
        }
    }

    static final class FlowableAsFlux<T>
    extends Flux<T>
    implements Fuseable {
        final Flowable<T> source;

        public FlowableAsFlux(Flowable<T> source) {
            this.source = source;
        }

        public void subscribe(CoreSubscriber<? super T> s) {
            if (s instanceof Fuseable.ConditionalSubscriber) {
                this.source.subscribe(new FlowableAsFluxConditionalSubscriber((Fuseable.ConditionalSubscriber)s));
            } else {
                this.source.subscribe(new FlowableAsFluxSubscriber<T>(s));
            }
        }

        static final class FlowableAsFluxConditionalSubscriber<T>
        implements ConditionalSubscriber<T>,
        Fuseable.QueueSubscription<T> {
            final Fuseable.ConditionalSubscriber<? super T> actual;
            Subscription s;
            QueueSubscription<T> qs;

            public FlowableAsFluxConditionalSubscriber(Fuseable.ConditionalSubscriber<? super T> actual) {
                this.actual = actual;
            }

            public void onSubscribe(Subscription s) {
                if (Operators.validate((Subscription)this.s, (Subscription)s)) {
                    this.s = s;
                    if (s instanceof QueueSubscription) {
                        this.qs = (QueueSubscription)s;
                    }
                    this.actual.onSubscribe((Subscription)this);
                }
            }

            public void onNext(T t) {
                this.actual.onNext(t);
            }

            public boolean tryOnNext(T t) {
                return this.actual.tryOnNext(t);
            }

            public void onError(Throwable t) {
                this.actual.onError(t);
            }

            public void onComplete() {
                this.actual.onComplete();
            }

            public void request(long n) {
                this.s.request(n);
            }

            public void cancel() {
                this.s.cancel();
            }

            public T poll() {
                try {
                    return (T)this.qs.poll();
                }
                catch (Throwable ex) {
                    throw Exceptions.bubble((Throwable)ex);
                }
            }

            public int size() {
                return 0;
            }

            public boolean isEmpty() {
                return this.qs.isEmpty();
            }

            public void clear() {
                this.qs.clear();
            }

            public int requestFusion(int requestedMode) {
                if (this.qs != null) {
                    return this.qs.requestFusion(requestedMode);
                }
                return 0;
            }
        }

        static final class FlowableAsFluxSubscriber<T>
        implements FlowableSubscriber<T>,
        Fuseable.QueueSubscription<T> {
            final Subscriber<? super T> actual;
            Subscription s;
            QueueSubscription<T> qs;

            public FlowableAsFluxSubscriber(Subscriber<? super T> actual) {
                this.actual = actual;
            }

            public void onSubscribe(Subscription s) {
                if (Operators.validate((Subscription)this.s, (Subscription)s)) {
                    this.s = s;
                    if (s instanceof QueueSubscription) {
                        this.qs = (QueueSubscription)s;
                    }
                    this.actual.onSubscribe((Subscription)this);
                }
            }

            public void onNext(T t) {
                this.actual.onNext(t);
            }

            public void onError(Throwable t) {
                this.actual.onError(t);
            }

            public void onComplete() {
                this.actual.onComplete();
            }

            public void request(long n) {
                this.s.request(n);
            }

            public void cancel() {
                this.s.cancel();
            }

            public T poll() {
                try {
                    return (T)this.qs.poll();
                }
                catch (Throwable ex) {
                    throw Exceptions.bubble((Throwable)ex);
                }
            }

            public int size() {
                return 0;
            }

            public boolean isEmpty() {
                return this.qs.isEmpty();
            }

            public void clear() {
                this.qs.clear();
            }

            public int requestFusion(int requestedMode) {
                if (this.qs != null) {
                    return this.qs.requestFusion(requestedMode);
                }
                return 0;
            }
        }
    }
}

