/*
 * Decompiled with CFR 0.152.
 */
package reactor.adapter.rxjava;

import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposable;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import reactor.core.scheduler.Scheduler;

public final class RxJava2Scheduler
implements reactor.core.scheduler.Scheduler {
    final Scheduler scheduler;

    public static reactor.core.scheduler.Scheduler from(Scheduler scheduler) {
        return new RxJava2Scheduler(scheduler);
    }

    RxJava2Scheduler(Scheduler scheduler) {
        this.scheduler = Objects.requireNonNull(scheduler, "scheduler");
    }

    public reactor.core.Disposable schedule(Runnable task) {
        Disposable s = this.scheduler.scheduleDirect(task);
        return () -> ((Disposable)s).dispose();
    }

    public reactor.core.Disposable schedule(Runnable task, long delay, TimeUnit unit) {
        Disposable s = this.scheduler.scheduleDirect(task, delay, unit);
        return () -> ((Disposable)s).dispose();
    }

    public reactor.core.Disposable schedulePeriodically(Runnable task, long initialDelay, long period, TimeUnit unit) {
        Disposable s = this.scheduler.schedulePeriodicallyDirect(task, initialDelay, period, unit);
        return () -> ((Disposable)s).dispose();
    }

    public Scheduler.Worker createWorker() {
        return new RxSchedulerWorker(this.scheduler.createWorker());
    }

    static final class RxSchedulerWorker
    implements Scheduler.Worker {
        final Scheduler.Worker w;

        RxSchedulerWorker(Scheduler.Worker w) {
            this.w = w;
        }

        public reactor.core.Disposable schedule(Runnable task) {
            Disposable s = this.w.schedule(task);
            return () -> ((Disposable)s).dispose();
        }

        public void dispose() {
            this.w.dispose();
        }

        public reactor.core.Disposable schedule(Runnable task, long delay, TimeUnit unit) {
            Disposable s = this.w.schedule(task, delay, unit);
            return () -> ((Disposable)s).dispose();
        }

        public reactor.core.Disposable schedulePeriodically(Runnable task, long initialDelay, long period, TimeUnit unit) {
            Disposable s = this.w.schedulePeriodically(task, initialDelay, period, unit);
            return () -> ((Disposable)s).dispose();
        }
    }
}

