/*
 * Decompiled with CFR 0.152.
 */
package reactor.scheduler.clock;

import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.util.concurrent.TimeUnit;
import reactor.core.scheduler.Scheduler;

public class SchedulerClock
extends Clock {
    private static final long NANOS_PER_SECOND = 1000000000L;
    private final Scheduler scheduler;
    private final ZoneId zone;

    private SchedulerClock(Scheduler scheduler, ZoneId zone) {
        this.scheduler = scheduler;
        this.zone = zone;
    }

    @Override
    public ZoneId getZone() {
        return this.zone;
    }

    @Override
    public SchedulerClock withZone(ZoneId zone) {
        return new SchedulerClock(this.scheduler, zone);
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public SchedulerClock withScheduler(Scheduler scheduler) {
        return new SchedulerClock(scheduler, this.zone);
    }

    @Override
    public long millis() {
        return this.scheduler.now(TimeUnit.MILLISECONDS);
    }

    @Override
    public Instant instant() {
        long nano = this.scheduler.now(TimeUnit.NANOSECONDS);
        long secs = Math.floorDiv(nano, 1000000000L);
        long nos = Math.floorMod(nano, 1000000000L);
        return Instant.ofEpochSecond(secs, nos);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SchedulerClock that = (SchedulerClock)o;
        return this.scheduler.equals(that.scheduler) && this.zone.equals(that.zone);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.scheduler.hashCode();
        result = 31 * result + this.zone.hashCode();
        return result;
    }

    public String toString() {
        return "SchedulerClock{scheduler=" + this.scheduler + ", zone=" + this.zone + '}';
    }

    public static SchedulerClock of(Scheduler scheduler) {
        return new SchedulerClock(scheduler, ZoneId.systemDefault());
    }

    public static SchedulerClock of(Scheduler scheduler, ZoneId zoneId) {
        return new SchedulerClock(scheduler, zoneId);
    }
}

