/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server.logging;

import io.netty.handler.codec.http.HttpMethod;
import java.net.SocketAddress;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.function.Supplier;
import reactor.netty.http.server.logging.AccessLogArgProvider;
import reactor.util.annotation.Nullable;

abstract class AbstractAccessLogArgProvider<SELF extends AbstractAccessLogArgProvider<SELF>>
implements AccessLogArgProvider,
Supplier<SELF> {
    static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("dd/MMM/yyyy:HH:mm:ss Z");
    static final String MISSING = "-";
    final SocketAddress remoteAddress;
    final String user = "-";
    String zonedDateTime;
    CharSequence method;
    CharSequence uri;
    String protocol;
    CharSequence status;
    boolean chunked;
    long contentLength = -1L;
    long startTime;

    AbstractAccessLogArgProvider(@Nullable SocketAddress remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    @Override
    @Nullable
    public String zonedDateTime() {
        return this.zonedDateTime;
    }

    @Override
    @Nullable
    public SocketAddress remoteAddress() {
        return this.remoteAddress;
    }

    @Override
    @Nullable
    public CharSequence method() {
        return this.method;
    }

    @Override
    @Nullable
    public CharSequence uri() {
        return this.uri;
    }

    @Override
    @Nullable
    public String protocol() {
        return this.protocol;
    }

    @Override
    @Nullable
    public String user() {
        return MISSING;
    }

    @Override
    @Nullable
    public CharSequence status() {
        return this.status;
    }

    @Override
    public long contentLength() {
        return this.contentLength;
    }

    @Override
    public long duration() {
        return System.currentTimeMillis() - this.startTime;
    }

    void onRequest() {
        this.zonedDateTime = ZonedDateTime.now(ZoneId.systemDefault()).format(DATE_TIME_FORMATTER);
        this.startTime = System.currentTimeMillis();
    }

    void clear() {
        this.zonedDateTime = null;
        this.method = null;
        this.uri = null;
        this.protocol = null;
        this.status = null;
        this.chunked = false;
        this.contentLength = -1L;
        this.startTime = 0L;
    }

    SELF status(CharSequence status) {
        this.status = Objects.requireNonNull(status, "status");
        return (SELF)((AbstractAccessLogArgProvider)this.get());
    }

    SELF chunked(boolean chunked) {
        this.chunked = chunked;
        return (SELF)((AbstractAccessLogArgProvider)this.get());
    }

    SELF increaseContentLength(long contentLength) {
        if (this.chunked && contentLength >= 0L && !HttpMethod.HEAD.asciiName().contentEqualsIgnoreCase(this.method)) {
            if (this.contentLength == -1L) {
                this.contentLength = 0L;
            }
            this.contentLength += contentLength;
        }
        return (SELF)((AbstractAccessLogArgProvider)this.get());
    }
}

