/*
 * Decompiled with CFR 0.152.
 */
package reactor.io.net.tcp;

import java.net.InetSocketAddress;
import reactor.Environment;
import reactor.core.Dispatcher;
import reactor.fn.Supplier;
import reactor.io.buffer.Buffer;
import reactor.io.codec.Codec;
import reactor.io.net.ChannelStream;
import reactor.io.net.ReactorClient;
import reactor.io.net.config.ClientSocketOptions;
import reactor.io.net.config.SslOptions;

public abstract class TcpClient<IN, OUT>
extends ReactorClient<IN, OUT, ChannelStream<IN, OUT>> {
    protected final Supplier<InetSocketAddress> connectAddress;
    private final ClientSocketOptions options;
    private final SslOptions sslOptions;

    protected TcpClient(Environment env, Dispatcher dispatcher, Supplier<InetSocketAddress> connectAddress, ClientSocketOptions options, SslOptions sslOptions, Codec<Buffer, IN, OUT> codec) {
        super(env, dispatcher, codec, options.prefetch());
        if (connectAddress == null) {
            final InetSocketAddress loopback = new InetSocketAddress("127.0.0.1", 3000);
            this.connectAddress = new Supplier<InetSocketAddress>(){

                public InetSocketAddress get() {
                    return loopback;
                }
            };
        } else {
            this.connectAddress = connectAddress;
        }
        this.options = options;
        this.sslOptions = sslOptions;
    }

    public InetSocketAddress getConnectAddress() {
        return (InetSocketAddress)this.connectAddress.get();
    }

    protected ClientSocketOptions getOptions() {
        return this.options;
    }

    protected SslOptions getSslOptions() {
        return this.sslOptions;
    }
}

