/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.exporter.internal.otlp.metrics;

import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.exporter.internal.marshal.Marshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.exporter.internal.otlp.metrics.LowAllocationMetricsRequestMarshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.exporter.internal.otlp.metrics.MetricsRequestMarshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.common.CompletableResultCode;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.common.export.MemoryMode;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.metrics.data.MetricData;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.function.BiFunction;

public class MetricReusableDataMarshaler {
    private final Deque<LowAllocationMetricsRequestMarshaler> marshalerPool = new ArrayDeque<LowAllocationMetricsRequestMarshaler>();
    private final MemoryMode memoryMode;
    private final BiFunction<Marshaler, Integer, CompletableResultCode> doExport;

    public MetricReusableDataMarshaler(MemoryMode memoryMode, BiFunction<Marshaler, Integer, CompletableResultCode> doExport) {
        this.memoryMode = memoryMode;
        this.doExport = doExport;
    }

    public MemoryMode getMemoryMode() {
        return this.memoryMode;
    }

    public CompletableResultCode export(Collection<MetricData> metrics) {
        if (this.memoryMode == MemoryMode.REUSABLE_DATA) {
            LowAllocationMetricsRequestMarshaler marshaler = this.marshalerPool.poll();
            if (marshaler == null) {
                marshaler = new LowAllocationMetricsRequestMarshaler();
            }
            LowAllocationMetricsRequestMarshaler exportMarshaler = marshaler;
            exportMarshaler.initialize(metrics);
            return this.doExport.apply(exportMarshaler, metrics.size()).whenComplete(() -> {
                exportMarshaler.reset();
                this.marshalerPool.add(exportMarshaler);
            });
        }
        MetricsRequestMarshaler request = MetricsRequestMarshaler.create(metrics);
        return this.doExport.apply(request, metrics.size());
    }
}

