/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.autoconfigure;

import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.autoconfigure.MetricExporterConfiguration;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.autoconfigure.internal.SpiHelper;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.autoconfigure.spi.ConfigProperties;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.autoconfigure.spi.ConfigurationException;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.autoconfigure.spi.internal.DefaultConfigProperties;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.metrics.SdkMeterProviderBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.metrics.export.MetricExporter;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.metrics.export.MetricReader;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.metrics.internal.SdkMeterProviderUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.metrics.internal.exemplar.ExemplarFilter;
import java.io.Closeable;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;

final class MeterProviderConfiguration {
    static void configureMeterProvider(SdkMeterProviderBuilder meterProviderBuilder, ConfigProperties config, SpiHelper spiHelper, BiFunction<? super MetricReader, ConfigProperties, ? extends MetricReader> metricReaderCustomizer, BiFunction<? super MetricExporter, ConfigProperties, ? extends MetricExporter> metricExporterCustomizer, List<Closeable> closeables) {
        String exemplarFilter;
        switch (exemplarFilter = config.getString("otel.metrics.exemplar.filter", "trace_based").toLowerCase(Locale.ROOT)) {
            case "always_off": {
                SdkMeterProviderUtil.setExemplarFilter(meterProviderBuilder, ExemplarFilter.alwaysOff());
                break;
            }
            case "always_on": {
                SdkMeterProviderUtil.setExemplarFilter(meterProviderBuilder, ExemplarFilter.alwaysOn());
                break;
            }
            default: {
                SdkMeterProviderUtil.setExemplarFilter(meterProviderBuilder, ExemplarFilter.traceBased());
            }
        }
        int cardinalityLimit = config.getInt("otel.experimental.metrics.cardinality.limit", 2000);
        if (cardinalityLimit < 1) {
            throw new ConfigurationException("otel.experimental.metrics.cardinality.limit must be >= 1");
        }
        MeterProviderConfiguration.configureMetricReaders(config, spiHelper, metricReaderCustomizer, metricExporterCustomizer, closeables).forEach(reader -> meterProviderBuilder.registerMetricReader((MetricReader)reader, instrumentType -> cardinalityLimit));
    }

    static List<MetricReader> configureMetricReaders(ConfigProperties config, SpiHelper spiHelper, BiFunction<? super MetricReader, ConfigProperties, ? extends MetricReader> metricReaderCustomizer, BiFunction<? super MetricExporter, ConfigProperties, ? extends MetricExporter> metricExporterCustomizer, List<Closeable> closeables) {
        Set<String> exporterNames = DefaultConfigProperties.getSet(config, "otel.metrics.exporter");
        if (exporterNames.contains("none")) {
            if (exporterNames.size() > 1) {
                throw new ConfigurationException("otel.metrics.exporter contains none along with other exporters");
            }
            return Collections.emptyList();
        }
        if (exporterNames.isEmpty()) {
            exporterNames = Collections.singleton("otlp");
        }
        return exporterNames.stream().map(exporterName -> MetricExporterConfiguration.configureReader(exporterName, config, spiHelper, metricReaderCustomizer, metricExporterCustomizer, closeables)).collect(Collectors.toList());
    }

    private MeterProviderConfiguration() {
    }
}

