/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.extension.incubator.fileconfig;

import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.autoconfigure.internal.SpiHelper;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.autoconfigure.spi.ConfigurationException;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.extension.incubator.fileconfig.Factory;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.extension.incubator.fileconfig.FileConfigUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.extension.incubator.fileconfig.internal.model.OtlpModel;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.extension.incubator.fileconfig.internal.model.SpanExporterModel;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.extension.incubator.fileconfig.internal.model.ZipkinModel;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.trace.export.SpanExporter;
import java.io.Closeable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

final class SpanExporterFactory
implements Factory<SpanExporterModel, SpanExporter> {
    private static final SpanExporterFactory INSTANCE = new SpanExporterFactory();

    private SpanExporterFactory() {
    }

    static SpanExporterFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public SpanExporter create(SpanExporterModel model, SpiHelper spiHelper, List<Closeable> closeables) {
        ZipkinModel zipkinModel;
        OtlpModel otlpModel = model.getOtlp();
        if (otlpModel != null) {
            model.getAdditionalProperties().put("otlp", otlpModel);
        }
        if (model.getConsole() != null) {
            model.getAdditionalProperties().put("console", model.getConsole());
        }
        if ((zipkinModel = model.getZipkin()) != null) {
            model.getAdditionalProperties().put("zipkin", model.getZipkin());
        }
        if (!model.getAdditionalProperties().isEmpty()) {
            Map<String, Object> additionalProperties = model.getAdditionalProperties();
            if (additionalProperties.size() > 1) {
                throw new ConfigurationException("Invalid configuration - multiple span exporters set: " + additionalProperties.keySet().stream().collect(Collectors.joining(",", "[", "]")));
            }
            Map.Entry exporterKeyValue = (Map.Entry)additionalProperties.entrySet().stream().findFirst().orElseThrow(() -> new IllegalStateException("Missing exporter. This is a programming error."));
            SpanExporter spanExporter = FileConfigUtil.loadComponent(spiHelper, SpanExporter.class, (String)exporterKeyValue.getKey(), exporterKeyValue.getValue());
            return FileConfigUtil.addAndReturn(closeables, spanExporter);
        }
        throw new ConfigurationException("span exporter must be set");
    }
}

