/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.instrumentation.dropwizard5.labels;

import io.prometheus.metrics.instrumentation.dropwizard5.labels.GraphiteNamePattern;
import io.prometheus.metrics.instrumentation.dropwizard5.labels.MapperConfig;
import io.prometheus.metrics.model.snapshots.Labels;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CustomLabelMapper {
    private final List<CompiledMapperConfig> compiledMapperConfigs;

    public CustomLabelMapper(List<MapperConfig> mapperConfigs) {
        if (mapperConfigs == null || mapperConfigs.isEmpty()) {
            throw new IllegalArgumentException("CustomLabelMapper needs some mapper configs!");
        }
        this.compiledMapperConfigs = new ArrayList<CompiledMapperConfig>(mapperConfigs.size());
        for (MapperConfig config : mapperConfigs) {
            this.compiledMapperConfigs.add(new CompiledMapperConfig(config));
        }
    }

    public Labels getLabels(String dropwizardName, List<String> additionalLabelNames, List<String> additionalLabelValues) {
        if (dropwizardName == null) {
            throw new IllegalArgumentException("Dropwizard metric name cannot be null");
        }
        CompiledMapperConfig matchingConfig = null;
        for (CompiledMapperConfig config : this.compiledMapperConfigs) {
            if (!config.pattern.matches(dropwizardName)) continue;
            matchingConfig = config;
            break;
        }
        if (matchingConfig != null) {
            Map<String, String> params = matchingConfig.pattern.extractParameters(dropwizardName);
            NameAndLabels nameAndLabels = this.getNameAndLabels(matchingConfig.mapperConfig, params);
            nameAndLabels.labelNames.addAll(additionalLabelNames);
            nameAndLabels.labelValues.addAll(additionalLabelValues);
            return Labels.of(nameAndLabels.labelNames, nameAndLabels.labelValues);
        }
        return Labels.of(additionalLabelNames, additionalLabelValues);
    }

    protected NameAndLabels getNameAndLabels(MapperConfig config, Map<String, String> parameters) {
        String metricName = this.formatTemplate(config.getName(), parameters);
        ArrayList<String> labels = new ArrayList<String>(config.getLabels().size());
        ArrayList<String> labelValues = new ArrayList<String>(config.getLabels().size());
        for (Map.Entry<String, String> entry : config.getLabels().entrySet()) {
            labels.add(entry.getKey());
            labelValues.add(this.formatTemplate(entry.getValue(), parameters));
        }
        return new NameAndLabels(metricName, labels, labelValues);
    }

    private String formatTemplate(String template, Map<String, String> params) {
        String result = template;
        for (Map.Entry<String, String> entry : params.entrySet()) {
            result = result.replace(entry.getKey(), entry.getValue());
        }
        return result;
    }

    static class CompiledMapperConfig {
        final MapperConfig mapperConfig;
        final GraphiteNamePattern pattern;

        CompiledMapperConfig(MapperConfig mapperConfig) {
            this.mapperConfig = mapperConfig;
            this.pattern = new GraphiteNamePattern(mapperConfig.getMatch());
        }
    }

    static class NameAndLabels {
        final String name;
        final List<String> labelNames;
        final List<String> labelValues;

        NameAndLabels(String name, List<String> labelNames, List<String> labelValues) {
            this.name = name;
            this.labelNames = labelNames;
            this.labelValues = labelValues;
        }
    }
}

