/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.util;

import io.qameta.allure.util.ObjectUtils;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.joor.Reflect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NamingUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(NamingUtils.class);
    private static final Collector<CharSequence, ?, String> JOINER = Collectors.joining(", ", "[", "]");

    private NamingUtils() {
        throw new IllegalStateException("Do not instance");
    }

    public static String processNameTemplate(String template, Map<String, Object> params) {
        Matcher matcher = Pattern.compile("\\{([^}]*)}").matcher(template);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String pattern = matcher.group(1);
            String replacement = NamingUtils.processPattern(pattern, params).orElseGet(matcher::group);
            matcher.appendReplacement(sb, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private static Optional<String> processPattern(String pattern, Map<String, Object> params) {
        if (pattern.isEmpty()) {
            LOGGER.error("Could not process empty pattern");
            return Optional.empty();
        }
        String[] parts = pattern.split("\\.");
        String parameterName = parts[0];
        if (!params.containsKey(parameterName)) {
            LOGGER.error("Could not find parameter " + parameterName);
            return Optional.empty();
        }
        Object param = params.get(parameterName);
        return Optional.ofNullable(NamingUtils.extractProperties(param, parts, 1));
    }

    private static String extractProperties(Object object, String[] parts, int index) {
        if (Objects.isNull(object)) {
            return "null";
        }
        if (index < parts.length) {
            if (object instanceof Object[]) {
                return Stream.of((Object[])object).map(child -> NamingUtils.extractProperties(child, parts, index)).collect(JOINER);
            }
            if (object instanceof Iterable) {
                Spliterator iterator = ((Iterable)object).spliterator();
                return StreamSupport.stream(iterator, false).map(child -> NamingUtils.extractProperties(child, parts, index)).collect(JOINER);
            }
            Object child2 = Reflect.on((Object)object).get(parts[index]);
            return NamingUtils.extractProperties(child2, parts, index + 1);
        }
        return ObjectUtils.toString(object);
    }
}

