/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.junitplatform;

import io.qameta.allure.Allure;
import io.qameta.allure.AllureLifecycle;
import io.qameta.allure.Description;
import io.qameta.allure.Severity;
import io.qameta.allure.SeverityLevel;
import io.qameta.allure.junitplatform.AllureJunitPlatformUtils;
import io.qameta.allure.model.FixtureResult;
import io.qameta.allure.model.Label;
import io.qameta.allure.model.Parameter;
import io.qameta.allure.model.Stage;
import io.qameta.allure.model.Status;
import io.qameta.allure.model.StatusDetails;
import io.qameta.allure.model.TestResult;
import io.qameta.allure.model.TestResultContainer;
import io.qameta.allure.util.AnnotationUtils;
import io.qameta.allure.util.ResultsUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.DisplayName;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.TestTag;
import org.junit.platform.engine.reporting.ReportEntry;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllureJunitPlatform
implements TestExecutionListener {
    public static final String ALLURE_REPORT_ENTRY_BLANK_PREFIX = "ALLURE_REPORT_ENTRY_BLANK_PREFIX__";
    public static final String ALLURE_PARAMETER = "allure.parameter";
    public static final String ALLURE_PARAMETER_VALUE_KEY = "value";
    public static final String ALLURE_PARAMETER_MODE_KEY = "mode";
    public static final String ALLURE_PARAMETER_EXCLUDED_KEY = "excluded";
    public static final String ALLURE_FIXTURE = "allure.fixture";
    public static final String PREPARE = "prepare";
    public static final String TEAR_DOWN = "tear_down";
    public static final String EVENT_START = "start";
    public static final String EVENT_STOP = "stop";
    public static final String EVENT_FAILURE = "failure";
    public static final String JUNIT_PLATFORM_UNIQUE_ID = "junit.platform.uniqueid";
    private static final Logger LOGGER = LoggerFactory.getLogger(AllureJunitPlatform.class);
    private static final String STDOUT = "stdout";
    private static final String STDERR = "stderr";
    private static final String TEXT_PLAIN = "text/plain";
    private static final String TXT_EXTENSION = ".txt";
    private static final boolean HAS_SPOCK2_IN_CLASSPATH = AllureJunitPlatform.isClassAvailableOnClasspath("io.qameta.allure.spock2.AllureSpock2");
    private static final String ENGINE_SPOCK2 = "spock";
    private final ThreadLocal<TestPlan> testPlanStorage = new InheritableThreadLocal<TestPlan>();
    private final ThreadLocal<Uuids> tests = new InheritableThreadLocal<Uuids>(){

        @Override
        protected Uuids initialValue() {
            return new Uuids();
        }
    };
    private final ThreadLocal<Uuids> containers = new InheritableThreadLocal<Uuids>(){

        @Override
        protected Uuids initialValue() {
            return new Uuids();
        }
    };
    private final AllureLifecycle lifecycle;

    public AllureJunitPlatform(AllureLifecycle lifecycle) {
        this.lifecycle = lifecycle;
    }

    public AllureJunitPlatform() {
        this.lifecycle = Allure.getLifecycle();
    }

    public AllureLifecycle getLifecycle() {
        return this.lifecycle;
    }

    private boolean shouldSkipReportingFor(TestIdentifier testIdentifier) {
        return !testIdentifier.getParentId().isPresent() || HAS_SPOCK2_IN_CLASSPATH && this.engineIs(testIdentifier, ENGINE_SPOCK2);
    }

    private boolean engineIs(TestIdentifier testIdentifier, String engineId) {
        return testIdentifier.getUniqueIdObject().getEngineId().filter(v -> Objects.equals(engineId, v)).isPresent();
    }

    private static boolean isClassAvailableOnClasspath(String clazz) {
        try {
            AllureJunitPlatform.class.getClassLoader().loadClass(clazz);
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public void testPlanExecutionStarted(TestPlan testPlan) {
        this.testPlanStorage.set(testPlan);
        this.tests.set(new Uuids());
        this.containers.set(new Uuids());
    }

    public void testPlanExecutionFinished(TestPlan testPlan) {
        this.testPlanStorage.remove();
        this.tests.remove();
        this.containers.remove();
    }

    public void executionStarted(TestIdentifier testIdentifier) {
        if (this.shouldSkipReportingFor(testIdentifier)) {
            return;
        }
        this.startTestContainer(testIdentifier);
        if (testIdentifier.isTest()) {
            this.startTestCase(testIdentifier);
        }
    }

    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        if (this.shouldSkipReportingFor(testIdentifier)) {
            return;
        }
        Status status = this.extractStatus(testExecutionResult);
        StatusDetails statusDetails = testExecutionResult.getThrowable().flatMap(ResultsUtils::getStatusDetails).orElse(null);
        if (testIdentifier.isTest()) {
            this.stopTestCase(testIdentifier, status, statusDetails);
        } else if (testExecutionResult.getStatus() != TestExecutionResult.Status.SUCCESSFUL) {
            this.startTestCase(testIdentifier);
            this.stopTestCase(testIdentifier, status, statusDetails);
        }
        this.stopTestContainer(testIdentifier);
    }

    public void executionSkipped(TestIdentifier testIdentifier, String reason) {
        if (this.shouldSkipReportingFor(testIdentifier)) {
            return;
        }
        TestPlan testPlan = this.testPlanStorage.get();
        if (Objects.isNull(testPlan)) {
            return;
        }
        this.reportNested(testPlan, testIdentifier, Status.SKIPPED, new StatusDetails().setMessage(reason), new HashSet<TestIdentifier>());
    }

    public void reportingEntryPublished(TestIdentifier testIdentifier, ReportEntry entry) {
        String content;
        if (this.shouldSkipReportingFor(testIdentifier)) {
            return;
        }
        Map<String, String> keyValuePairs = this.unwrap(entry.getKeyValuePairs());
        if (keyValuePairs.containsKey(ALLURE_FIXTURE)) {
            this.processFixtureEvent(testIdentifier, keyValuePairs);
            return;
        }
        if (keyValuePairs.containsKey(ALLURE_PARAMETER)) {
            this.processParameterEvent(keyValuePairs);
            return;
        }
        if (keyValuePairs.containsKey(STDOUT)) {
            content = keyValuePairs.getOrDefault(STDOUT, "");
            this.getLifecycle().addAttachment("Stdout", TEXT_PLAIN, TXT_EXTENSION, content.getBytes(StandardCharsets.UTF_8));
        }
        if (keyValuePairs.containsKey(STDERR)) {
            content = keyValuePairs.getOrDefault(STDERR, "");
            this.getLifecycle().addAttachment("Stderr", TEXT_PLAIN, TXT_EXTENSION, content.getBytes(StandardCharsets.UTF_8));
        }
    }

    private Map<String, String> unwrap(Map<String, String> data) {
        HashMap<String, String> res = new HashMap<String, String>();
        data.forEach((key, value) -> {
            if (Objects.nonNull(value) && value.trim().isEmpty() && value.startsWith(ALLURE_REPORT_ENTRY_BLANK_PREFIX)) {
                res.put((String)key, value.substring(ALLURE_REPORT_ENTRY_BLANK_PREFIX.length()));
            } else {
                res.put((String)key, (String)value);
            }
        });
        return res;
    }

    private void processParameterEvent(Map<String, String> keyValuePairs) {
        String name = keyValuePairs.get(ALLURE_PARAMETER);
        String value = keyValuePairs.get(ALLURE_PARAMETER_VALUE_KEY);
        Parameter parameter = Objects.nonNull(value) && value.startsWith(ALLURE_REPORT_ENTRY_BLANK_PREFIX) ? ResultsUtils.createParameter((String)name, (Object)value.substring(ALLURE_REPORT_ENTRY_BLANK_PREFIX.length())) : ResultsUtils.createParameter((String)name, (Object)value);
        if (keyValuePairs.containsKey(ALLURE_PARAMETER_MODE_KEY)) {
            String modeString = keyValuePairs.get(ALLURE_PARAMETER_MODE_KEY);
            Stream.of(Parameter.Mode.values()).filter(mode -> mode.name().equalsIgnoreCase(modeString)).findAny().ifPresent(arg_0 -> ((Parameter)parameter).setMode(arg_0));
        }
        if (keyValuePairs.containsKey(ALLURE_PARAMETER_EXCLUDED_KEY)) {
            String excludedString = keyValuePairs.get(ALLURE_PARAMETER_EXCLUDED_KEY);
            Optional.ofNullable(excludedString).map(Boolean::parseBoolean).ifPresent(arg_0 -> ((Parameter)parameter).setExcluded(arg_0));
        }
        this.getLifecycle().updateTestCase(tr -> tr.getParameters().add(parameter));
    }

    private void processFixtureEvent(TestIdentifier testIdentifier, Map<String, String> keyValuePairs) {
        String type = keyValuePairs.get(ALLURE_FIXTURE);
        String event = keyValuePairs.get("event");
        if (Objects.isNull(type) || Objects.isNull(event)) {
            return;
        }
        switch (event) {
            case "start": {
                Optional<String> maybeParent = this.getContainer(testIdentifier);
                if (!maybeParent.isPresent()) {
                    return;
                }
                String parentUuid = maybeParent.get();
                this.startFixture(parentUuid, type, keyValuePairs);
                return;
            }
            case "failure": {
                this.failFixture(keyValuePairs);
                this.resetContext(testIdentifier);
                return;
            }
            case "stop": {
                this.stopFixture(keyValuePairs);
                this.resetContext(testIdentifier);
                return;
            }
        }
    }

    private void resetContext(TestIdentifier testIdentifier) {
        Optional.of(testIdentifier).filter(TestIdentifier::isTest).flatMap(this::getTest).ifPresent(arg_0 -> ((AllureLifecycle)Allure.getLifecycle()).setCurrentTestCase(arg_0));
    }

    private void reportNested(TestPlan testPlan, TestIdentifier testIdentifier, Status status, StatusDetails statusDetails, Set<TestIdentifier> visited) {
        Set children = testPlan.getChildren(testIdentifier);
        if (testIdentifier.isTest() || children.isEmpty()) {
            this.startTestCase(testIdentifier);
            this.stopTestCase(testIdentifier, status, statusDetails);
        }
        visited.add(testIdentifier);
        children.stream().filter(id -> !visited.contains(id)).forEach(child -> this.reportNested(testPlan, (TestIdentifier)child, status, statusDetails, visited));
    }

    protected Status getStatus(Throwable throwable) {
        return ResultsUtils.getStatus((Throwable)throwable).orElse(Status.FAILED);
    }

    private void startTestContainer(TestIdentifier testIdentifier) {
        String uuid = this.getOrCreateContainer(testIdentifier);
        TestResultContainer result = new TestResultContainer().setUuid(uuid).setName(testIdentifier.getDisplayName());
        this.getLifecycle().startTestContainer(result);
    }

    private void stopTestContainer(TestIdentifier testIdentifier) {
        Optional<String> maybeUuid = this.getContainer(testIdentifier);
        if (!maybeUuid.isPresent()) {
            return;
        }
        String uuid = maybeUuid.get();
        TestPlan context = this.testPlanStorage.get();
        List children = Optional.ofNullable(context).map(tp -> tp.getDescendants(testIdentifier)).orElseGet(Collections::emptySet).stream().filter(TestIdentifier::isTest).map(this::getTest).filter(Optional::isPresent).map(Optional::get).distinct().collect(Collectors.toCollection(ArrayList::new));
        this.getTest(testIdentifier).ifPresent(children::add);
        this.getLifecycle().updateTestContainer(uuid, container -> container.setChildren(children));
        this.getLifecycle().stopTestContainer(uuid);
        this.getLifecycle().writeTestContainer(uuid);
    }

    private void startFixture(String parentUuid, String type, Map<String, String> keyValue) {
        String uuid = keyValue.get("uuid");
        if (Objects.isNull(uuid)) {
            return;
        }
        String name = keyValue.getOrDefault("name", "Unknown");
        FixtureResult result = new FixtureResult().setName(name);
        switch (type) {
            case "prepare": {
                this.getLifecycle().startPrepareFixture(parentUuid, uuid, result);
                return;
            }
            case "tear_down": {
                this.getLifecycle().startTearDownFixture(parentUuid, uuid, result);
                return;
            }
        }
        LOGGER.debug("unknown fixture type {}", (Object)type);
    }

    private void failFixture(Map<String, String> keyValue) {
        String uuid = keyValue.get("uuid");
        if (Objects.isNull(uuid)) {
            return;
        }
        this.getLifecycle().updateFixture(uuid, fixtureResult -> {
            Optional.of((String)keyValue.get("status")).map(Status::fromValue).ifPresent(arg_0 -> ((FixtureResult)fixtureResult).setStatus(arg_0));
            fixtureResult.setStatusDetails(new StatusDetails());
            Optional.of((String)keyValue.get("message")).ifPresent(arg_0 -> ((StatusDetails)fixtureResult.getStatusDetails()).setMessage(arg_0));
            Optional.of((String)keyValue.get("trace")).ifPresent(arg_0 -> ((StatusDetails)fixtureResult.getStatusDetails()).setTrace(arg_0));
        });
        this.getLifecycle().stopFixture(uuid);
    }

    private void stopFixture(Map<String, String> keyValue) {
        String uuid = keyValue.get("uuid");
        if (Objects.isNull(uuid)) {
            return;
        }
        this.getLifecycle().updateFixture(uuid, fixtureResult -> fixtureResult.setStatus(Status.PASSED));
        this.getLifecycle().stopFixture(uuid);
    }

    private void startTestCase(TestIdentifier testIdentifier) {
        String uuid = this.getOrCreateTest(testIdentifier);
        Optional testSource = testIdentifier.getSource();
        Optional<Object> testMethod = testSource.flatMap(AllureJunitPlatformUtils::getTestMethod);
        Optional<Set> testClass = testSource.flatMap(AllureJunitPlatformUtils::getTestClass);
        boolean testTemplate = "test-template-invocation".equals(testIdentifier.getUniqueIdObject().getLastSegment().getType());
        Optional<String> maybeParent = Optional.of(this.testPlanStorage).map(ThreadLocal::get).flatMap(tp -> tp.getParent(testIdentifier));
        TestResult result = new TestResult().setUuid(uuid).setName(testTemplate && maybeParent.isPresent() ? ((TestIdentifier)maybeParent.get()).getDisplayName() + " " + testIdentifier.getDisplayName() : testIdentifier.getDisplayName()).setLabels(this.getTags(testIdentifier)).setTestCaseId(testTemplate ? maybeParent.map(TestIdentifier::getUniqueId).orElseGet(() -> ((TestIdentifier)testIdentifier).getUniqueId()) : testIdentifier.getUniqueId()).setTestCaseName(testTemplate ? maybeParent.map(TestIdentifier::getDisplayName).orElseGet(() -> ((TestIdentifier)testIdentifier).getDisplayName()) : testIdentifier.getDisplayName()).setHistoryId(this.getHistoryId(testIdentifier)).setStage(Stage.RUNNING);
        if (testTemplate) {
            result.getParameters().add(new Parameter().setMode(Parameter.Mode.HIDDEN).setName("UniqueId").setValue(testIdentifier.getUniqueId()));
        }
        result.getLabels().addAll(ResultsUtils.getProvidedLabels());
        result.getLabels().add(this.getJUnitPlatformUniqueId(testIdentifier));
        testClass.map(AnnotationUtils::getLabels).ifPresent(result.getLabels()::addAll);
        testMethod.map(AnnotationUtils::getLabels).ifPresent(result.getLabels()::addAll);
        testClass.map(AnnotationUtils::getLinks).ifPresent(result.getLinks()::addAll);
        testMethod.map(AnnotationUtils::getLinks).ifPresent(result.getLinks()::addAll);
        result.getLabels().addAll(Arrays.asList(ResultsUtils.createHostLabel(), ResultsUtils.createThreadLabel(), ResultsUtils.createFrameworkLabel((String)"junit-platform"), ResultsUtils.createLanguageLabel((String)"java")));
        testSource.flatMap(AllureJunitPlatformUtils::getFullName).ifPresent(arg_0 -> ((TestResult)result).setFullName(arg_0));
        testSource.map(this::getSourceLabels).ifPresent(result.getLabels()::addAll);
        testClass.ifPresent(aClass -> {
            String suiteName = this.getDisplayName((AnnotatedElement)aClass).orElse(aClass.getCanonicalName());
            result.getLabels().add(ResultsUtils.createSuiteLabel((String)suiteName));
        });
        Optional classDescription = testClass.flatMap(this::getDescription);
        Optional methodDescription = testMethod.flatMap(this::getDescription);
        String description = Stream.of(classDescription, methodDescription).filter(Optional::isPresent).map(Optional::get).collect(Collectors.joining("\n\n"));
        result.setDescription(description);
        testMethod.map(this::getSeverity).filter(Optional::isPresent).orElse(testClass.flatMap(this::getSeverity)).map(ResultsUtils::createSeverityLabel).ifPresent(result.getLabels()::add);
        testMethod.ifPresent(method -> ResultsUtils.processDescription((ClassLoader)method.getDeclaringClass().getClassLoader(), (Method)method, arg_0 -> ((TestResult)result).setDescription(arg_0), arg_0 -> ((TestResult)result).setDescriptionHtml(arg_0)));
        this.getLifecycle().scheduleTestCase(result);
        this.getLifecycle().startTestCase(uuid);
    }

    private void stopTestCase(TestIdentifier testIdentifier, Status status, StatusDetails statusDetails) {
        Optional<String> maybeUuid = this.getTest(testIdentifier);
        if (!maybeUuid.isPresent()) {
            return;
        }
        String uuid = maybeUuid.get();
        this.getLifecycle().updateTestCase(uuid, result -> {
            if (!testIdentifier.isTest()) {
                result.getLabels().add(new Label().setName("AS_ID").setValue("-1"));
            }
            result.setStage(Stage.FINISHED);
            result.setStatus(status);
            StatusDetails currentSd = result.getStatusDetails();
            if (Objects.isNull(currentSd)) {
                result.setStatusDetails(statusDetails);
            } else if (Objects.nonNull(statusDetails)) {
                Optional.of(statusDetails).map(StatusDetails::getMessage).ifPresent(arg_0 -> ((StatusDetails)currentSd).setMessage(arg_0));
                Optional.of(statusDetails).map(StatusDetails::getTrace).ifPresent(arg_0 -> ((StatusDetails)currentSd).setTrace(arg_0));
                currentSd.setMuted(currentSd.isMuted() || statusDetails.isMuted());
                currentSd.setFlaky(currentSd.isFlaky() || statusDetails.isFlaky());
                currentSd.setKnown(currentSd.isKnown() || statusDetails.isKnown());
            }
        });
        this.getLifecycle().stopTestCase(uuid);
        this.getLifecycle().writeTestCase(uuid);
    }

    private Status extractStatus(TestExecutionResult testExecutionResult) {
        switch (testExecutionResult.getStatus()) {
            case FAILED: {
                return testExecutionResult.getThrowable().isPresent() ? this.getStatus((Throwable)testExecutionResult.getThrowable().get()) : Status.FAILED;
            }
            case SUCCESSFUL: {
                return Status.PASSED;
            }
        }
        return Status.SKIPPED;
    }

    private List<Label> getTags(TestIdentifier testIdentifier) {
        return testIdentifier.getTags().stream().map(TestTag::getName).map(ResultsUtils::createTagLabel).collect(Collectors.toList());
    }

    protected String getHistoryId(TestIdentifier testIdentifier) {
        return this.md5(testIdentifier.getUniqueId());
    }

    private String md5(String source) {
        byte[] bytes = ResultsUtils.getMd5Digest().digest(source.getBytes(StandardCharsets.UTF_8));
        return new BigInteger(1, bytes).toString(16);
    }

    private Optional<SeverityLevel> getSeverity(AnnotatedElement annotatedElement) {
        return this.getAnnotations(annotatedElement, Severity.class).map(Severity::value).findAny();
    }

    private Optional<String> getDisplayName(AnnotatedElement annotatedElement) {
        return this.getAnnotations(annotatedElement, DisplayName.class).map(DisplayName::value).findAny();
    }

    private Optional<String> getDescription(AnnotatedElement annotatedElement) {
        return this.getAnnotations(annotatedElement, Description.class).map(Description::value).findAny();
    }

    private <T extends Annotation> Stream<T> getAnnotations(AnnotatedElement annotatedElement, Class<T> annotationClass) {
        return Stream.of(annotatedElement.getAnnotationsByType(annotationClass));
    }

    private List<Label> getSourceLabels(TestSource source) {
        if (source instanceof MethodSource) {
            MethodSource ms = (MethodSource)source;
            return Arrays.asList(ResultsUtils.createPackageLabel((String)ms.getClassName()), ResultsUtils.createTestClassLabel((String)ms.getClassName()), ResultsUtils.createTestMethodLabel((String)ms.getMethodName()));
        }
        if (source instanceof ClassSource) {
            ClassSource cs = (ClassSource)source;
            return Arrays.asList(ResultsUtils.createPackageLabel((String)cs.getClassName()), ResultsUtils.createTestClassLabel((String)cs.getClassName()));
        }
        return Collections.emptyList();
    }

    private Label getJUnitPlatformUniqueId(TestIdentifier testIdentifier) {
        Label label = new Label();
        label.setName(JUNIT_PLATFORM_UNIQUE_ID);
        label.setValue(testIdentifier.getUniqueId());
        return label;
    }

    private Optional<String> getContainer(TestIdentifier testIdentifier) {
        return this.containers.get().get(testIdentifier);
    }

    private String getOrCreateContainer(TestIdentifier testIdentifier) {
        return this.containers.get().getOrCreate(testIdentifier);
    }

    private Optional<String> getTest(TestIdentifier testIdentifier) {
        return this.tests.get().get(testIdentifier);
    }

    private String getOrCreateTest(TestIdentifier testIdentifier) {
        return this.tests.get().getOrCreate(testIdentifier);
    }

    private static class Uuids {
        private final Map<TestIdentifier, String> storage = new ConcurrentHashMap<TestIdentifier, String>();
        private final ReadWriteLock lock = new ReentrantReadWriteLock();

        private Uuids() {
        }

        public Optional<String> get(TestIdentifier testIdentifier) {
            try {
                this.lock.readLock().lock();
                Optional<String> optional = Optional.ofNullable(this.storage.get(testIdentifier));
                return optional;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        private String getOrCreate(TestIdentifier testIdentifier) {
            try {
                this.lock.writeLock().lock();
                String string = this.storage.computeIfAbsent(testIdentifier, ti -> UUID.randomUUID().toString());
                return string;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }
}

