/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.maven;

public final class DownloadUtils {
    private static final String BINTRAY_TEMPLATE = "https://dl.bintray.com/qameta/generic/io/qameta/allure/allure/%s/allure-%s.zip";
    private static final String BY_DOT = "\\.";

    private DownloadUtils() {
        throw new IllegalStateException("do not instance");
    }

    public static String getAllureDownloadUrl(String version, String downloadUrl) {
        if (downloadUrl != null) {
            return downloadUrl;
        }
        if (DownloadUtils.versionCompare(version, "2.8.0") < 0) {
            return BINTRAY_TEMPLATE;
        }
        return null;
    }

    private static Integer versionCompare(String first, String second) {
        int i;
        String[] firstVersions = first.split(BY_DOT);
        String[] secondVersions = second.split(BY_DOT);
        for (i = 0; i < firstVersions.length && i < secondVersions.length && firstVersions[i].equals(secondVersions[i]); ++i) {
        }
        if (i < firstVersions.length && i < secondVersions.length) {
            int diff = Integer.valueOf(firstVersions[i]).compareTo(Integer.valueOf(secondVersions[i]));
            return Integer.signum(diff);
        }
        return Integer.signum(firstVersions.length - secondVersions.length);
    }
}

