/*
 * Decompiled with CFR 0.152.
 */
package io.qase.testng;

import io.qase.api.StepStorage;
import io.qase.api.services.QaseTestCaseListener;
import io.qase.api.utils.IntegrationUtils;
import io.qase.client.model.ResultCreate;
import io.qase.client.model.ResultCreateCase;
import io.qase.testng.guice.module.TestNgModule;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestResult;
import org.testng.TestListenerAdapter;

public class QaseListener
extends TestListenerAdapter
implements ITestListener {
    private static final String REPORTER_NAME = "TestNG";
    private final AtomicReference<Object> qaseTestCaseListener = new AtomicReference();

    public void onTestStart(ITestResult result) {
        this.getQaseTestCaseListener().onTestCaseStarted();
        super.onTestStart(result);
    }

    public void onTestSuccess(ITestResult tr) {
        this.getQaseTestCaseListener().onTestCaseFinished(resultCreate -> this.setupResultItem((ResultCreate)resultCreate, tr, ResultCreate.StatusEnum.PASSED));
        super.onTestSuccess(tr);
    }

    public void onTestFailure(ITestResult tr) {
        this.getQaseTestCaseListener().onTestCaseFinished(resultCreate -> this.setupResultItem((ResultCreate)resultCreate, tr, ResultCreate.StatusEnum.FAILED));
        super.onTestFailure(tr);
    }

    public void onFinish(ITestContext testContext) {
        this.getQaseTestCaseListener().onTestCasesSetFinished();
        super.onFinish(testContext);
    }

    private void setupResultItem(ResultCreate resultCreate, ITestResult result, ResultCreate.StatusEnum status) {
        Optional<Throwable> resultThrowable = Optional.ofNullable(result.getThrowable());
        String comment = resultThrowable.flatMap(throwable -> Optional.of(throwable.toString())).orElse(null);
        Boolean isDefect = resultThrowable.flatMap(throwable -> Optional.of(throwable instanceof AssertionError)).orElse(false);
        String stacktrace = resultThrowable.flatMap(throwable -> Optional.of(IntegrationUtils.getStacktrace((Throwable)throwable))).orElse(null);
        Method method = result.getMethod().getConstructorOrMethod().getMethod();
        Long caseId = IntegrationUtils.getCaseId((Method)method);
        String caseTitle = null;
        if (caseId == null) {
            caseTitle = IntegrationUtils.getCaseTitle((Method)method);
        }
        LinkedList steps = StepStorage.stopSteps();
        resultCreate._case(caseTitle == null ? null : new ResultCreateCase().title(caseTitle)).caseId(caseId).status(status).comment(comment).stacktrace(stacktrace).steps((List)(steps.isEmpty() ? null : steps)).defect(isDefect);
    }

    private static QaseTestCaseListener createQaseListener() {
        return (QaseTestCaseListener)TestNgModule.getInjector().getInstance(QaseTestCaseListener.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QaseTestCaseListener getQaseTestCaseListener() {
        Object value = this.qaseTestCaseListener.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.qaseTestCaseListener;
            synchronized (atomicReference) {
                value = this.qaseTestCaseListener.get();
                if (value == null) {
                    QaseTestCaseListener actualValue = QaseListener.createQaseListener();
                    value = actualValue == null ? this.qaseTestCaseListener : actualValue;
                    this.qaseTestCaseListener.set(value);
                }
            }
        }
        return (QaseTestCaseListener)(value == this.qaseTestCaseListener ? null : value);
    }

    static {
        System.setProperty("QASE_CLIENT_REPORTER_NAME", REPORTER_NAME);
    }
}

