/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.kms.runtime;

import io.quarkus.arc.DefaultBean;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Produces;
import software.amazon.awssdk.services.kms.KmsAsyncClient;
import software.amazon.awssdk.services.kms.KmsAsyncClientBuilder;
import software.amazon.awssdk.services.kms.KmsClient;
import software.amazon.awssdk.services.kms.KmsClientBuilder;

@ApplicationScoped
public class KmsClientProducer {
    private final KmsClient syncClient;
    private final KmsAsyncClient asyncClient;

    KmsClientProducer(Instance<KmsClientBuilder> syncClientBuilderInstance, Instance<KmsAsyncClientBuilder> asyncClientBuilderInstance) {
        this.syncClient = syncClientBuilderInstance.isResolvable() ? (KmsClient)((KmsClientBuilder)syncClientBuilderInstance.get()).build() : null;
        this.asyncClient = asyncClientBuilderInstance.isResolvable() ? (KmsAsyncClient)((KmsAsyncClientBuilder)asyncClientBuilderInstance.get()).build() : null;
    }

    @DefaultBean
    @Produces
    @ApplicationScoped
    public KmsClient client() {
        if (this.syncClient == null) {
            throw new IllegalStateException("The KmsClient is required but has not been detected/configured.");
        }
        return this.syncClient;
    }

    @DefaultBean
    @Produces
    @ApplicationScoped
    public KmsAsyncClient asyncClient() {
        if (this.asyncClient == null) {
            throw new IllegalStateException("The KmsAsyncClient is required but has not been detected/configured.");
        }
        return this.asyncClient;
    }

    @PreDestroy
    public void destroy() {
        if (this.syncClient != null) {
            this.syncClient.close();
        }
        if (this.asyncClient != null) {
            this.asyncClient.close();
        }
    }
}

