/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.artemis.core.runtime;

import io.quarkus.runtime.annotations.ConfigGroup;
import java.util.Optional;

@ConfigGroup
public interface ArtemisDevServicesBuildTimeConfig {
    public Optional<Boolean> enabled();

    public Optional<Integer> port();

    public Optional<String> imageName();

    public Optional<Boolean> shared();

    public Optional<String> serviceName();

    public Optional<String> user();

    public Optional<String> password();

    public Optional<String> extraArgs();

    default public boolean isEnabled() {
        return this.enabled().orElse(true);
    }

    default public int getPort() {
        return this.port().orElse(0);
    }

    default public String getImageName() {
        return this.imageName().orElse("quay.io/artemiscloud/activemq-artemis-broker:artemis.2.36.0");
    }

    default public boolean isShared() {
        return this.shared().orElse(true);
    }

    default public String getServiceName() {
        return this.serviceName().orElse("artemis");
    }

    default public String getUser() {
        return this.user().orElse("admin");
    }

    default public String getPassword() {
        return this.password().orElse("admin");
    }

    default public String getExtraArgs() {
        return this.extraArgs().orElse("--no-autotune --mapped --no-fsync");
    }

    default public boolean isEmpty() {
        return this.enabled().isEmpty() && this.port().isEmpty() && this.imageName().isEmpty() && this.shared().isEmpty() && this.serviceName().isEmpty() && this.user().isEmpty() && this.password().isEmpty() && this.extraArgs().isEmpty();
    }
}

