/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.artemis.core.runtime.health;

import io.quarkus.artemis.core.runtime.ArtemisBuildTimeConfigs;
import io.quarkus.artemis.core.runtime.ArtemisRuntimeConfigs;
import io.quarkus.artemis.core.runtime.ArtemisUtil;
import io.quarkus.artemis.core.runtime.health.ArtemisHealthSupport;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Instance;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;
import org.eclipse.microprofile.health.Readiness;

@Readiness
@ApplicationScoped
public class ServerLocatorHealthCheck
implements HealthCheck {
    private final Instance<ServerLocator> serverLocators;
    private final Set<String> serverLocatorNames;

    public ServerLocatorHealthCheck(ArtemisRuntimeConfigs runtimeConfigs, ArtemisBuildTimeConfigs buildTimeConfigs, ArtemisHealthSupport support, @Any Instance<ServerLocator> serverLocators) {
        this.serverLocators = serverLocators;
        this.serverLocatorNames = support.getConfiguredNames().stream().filter(name -> runtimeConfigs.configs().get(name).isHealthInclude()).collect(Collectors.toCollection(HashSet::new));
        this.serverLocatorNames.addAll(ArtemisUtil.getExternalNames(ServerLocator.class, runtimeConfigs, buildTimeConfigs));
    }

    public HealthCheckResponse call() {
        HealthCheckResponseBuilder builder = HealthCheckResponse.named((String)"Artemis Core health check").up();
        for (String name : this.serverLocatorNames) {
            Annotation identifier = ArtemisUtil.toIdentifier(name);
            try {
                ClientSessionFactory ignored = ((ServerLocator)this.serverLocators.select(new Annotation[]{identifier}).get()).createSessionFactory();
                try {
                    builder.withData(name, "UP");
                }
                finally {
                    if (ignored == null) continue;
                    ignored.close();
                }
            }
            catch (Exception e) {
                builder.withData(name, "DOWN").down();
            }
        }
        return builder.build();
    }
}

