/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.googlecloudservices.common.grpc.runtime.graal;

import com.google.api.core.ApiFunction;
import com.google.api.gax.grpc.ChannelPrimer;
import com.google.api.gax.grpc.GrpcHeaderInterceptor;
import com.google.api.gax.grpc.GrpcInterceptorProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.quarkiverse.googlecloudservices.common.grpc.runtime.graal.Target_com_google_api_gax_grpc_GrpcChannelUUIDInterceptor;
import io.quarkiverse.googlecloudservices.common.grpc.runtime.graal.Target_com_google_api_gax_grpc_GrpcMetadataHandlerInterceptor;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.threeten.bp.Duration;

@TargetClass(className="com.google.api.gax.grpc.InstantiatingGrpcChannelProvider")
final class Target_com_google_api_gax_grpc_InstantiatingGrpcChannelProvider {
    @Alias
    private Executor executor;
    @Alias
    private HeaderProvider headerProvider;
    @Alias
    private GrpcInterceptorProvider interceptorProvider;
    @Alias
    private String endpoint;
    @Alias
    private Integer maxInboundMessageSize;
    @Alias
    private Integer maxInboundMetadataSize;
    @Alias
    private Duration keepAliveTime;
    @Alias
    private Duration keepAliveTimeout;
    @Alias
    private Boolean keepAliveWithoutCalls;
    @Alias
    private ChannelPrimer channelPrimer;
    @Alias
    private ApiFunction<ManagedChannelBuilder, ManagedChannelBuilder> channelConfigurator;

    Target_com_google_api_gax_grpc_InstantiatingGrpcChannelProvider() {
    }

    @Substitute
    private ManagedChannel createSingleChannel() throws IOException {
        GrpcHeaderInterceptor headerInterceptor = new GrpcHeaderInterceptor(this.headerProvider.getHeaders());
        Target_com_google_api_gax_grpc_GrpcMetadataHandlerInterceptor metadataHandlerInterceptor = new Target_com_google_api_gax_grpc_GrpcMetadataHandlerInterceptor();
        int colon = this.endpoint.lastIndexOf(58);
        if (colon < 0) {
            throw new IllegalStateException("invalid endpoint - should have been validated: " + this.endpoint);
        }
        int port = Integer.parseInt(this.endpoint.substring(colon + 1));
        String serviceAddress = this.endpoint.substring(0, colon);
        ManagedChannelBuilder builder = ManagedChannelBuilder.forAddress((String)serviceAddress, (int)port);
        builder = builder.disableServiceConfigLookUp().intercept(new ClientInterceptor[]{new Target_com_google_api_gax_grpc_GrpcChannelUUIDInterceptor()}).intercept(new ClientInterceptor[]{headerInterceptor}).intercept(new ClientInterceptor[]{metadataHandlerInterceptor}).userAgent(headerInterceptor.getUserAgentHeader()).executor(this.executor);
        if (this.maxInboundMetadataSize != null) {
            builder.maxInboundMetadataSize(this.maxInboundMetadataSize.intValue());
        }
        if (this.maxInboundMessageSize != null) {
            builder.maxInboundMessageSize(this.maxInboundMessageSize.intValue());
        }
        if (this.keepAliveTime != null) {
            builder.keepAliveTime(this.keepAliveTime.toMillis(), TimeUnit.MILLISECONDS);
        }
        if (this.keepAliveTimeout != null) {
            builder.keepAliveTimeout(this.keepAliveTimeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        if (this.keepAliveWithoutCalls != null) {
            builder.keepAliveWithoutCalls(this.keepAliveWithoutCalls.booleanValue());
        }
        if (this.interceptorProvider != null) {
            builder.intercept(this.interceptorProvider.getInterceptors());
        }
        if (this.channelConfigurator != null) {
            builder = (ManagedChannelBuilder)this.channelConfigurator.apply((Object)builder);
        }
        ManagedChannel managedChannel = builder.build();
        if (this.channelPrimer != null) {
            this.channelPrimer.primeChannel(managedChannel);
        }
        return managedChannel;
    }
}

