/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.googlecloudservices.common;

import com.google.auth.Credentials;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.GoogleCredentials;
import io.quarkiverse.googlecloudservices.common.GcpBootstrapConfiguration;
import io.quarkiverse.googlecloudservices.common.GcpConfigHolder;
import io.quarkus.security.credential.Credential;
import io.quarkus.security.credential.TokenCredential;
import io.quarkus.security.identity.SecurityIdentity;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ContextNotActiveException;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;

@Singleton
public class GcpCredentialProducer {
    private static final String CLOUD_OAUTH_SCOPE = "https://www.googleapis.com/auth/cloud-platform";
    @Inject
    Instance<SecurityIdentity> securityIdentity;
    @Inject
    GcpConfigHolder gcpConfigHolder;

    @PostConstruct
    public void verifySecurityIdentity() {
        if (this.securityIdentity.isResolvable() && this.securityIdentity.isAmbiguous()) {
            throw new IllegalStateException("Multiple " + SecurityIdentity.class + " beans registered");
        }
    }

    @Produces
    @Singleton
    @Default
    public Credentials googleCredential() throws IOException {
        GcpBootstrapConfiguration gcpConfiguration = this.gcpConfigHolder.getBootstrapConfig();
        if (gcpConfiguration.serviceAccountLocation().isPresent()) {
            try (FileInputStream is = new FileInputStream(gcpConfiguration.serviceAccountLocation().get());){
                GoogleCredentials googleCredentials = GoogleCredentials.fromStream((InputStream)is).createScoped(new String[]{CLOUD_OAUTH_SCOPE});
                return googleCredentials;
            }
        }
        if (gcpConfiguration.serviceAccountEncodedKey().isPresent()) {
            byte[] decode = Base64.getDecoder().decode(gcpConfiguration.serviceAccountEncodedKey().get());
            try (ByteArrayInputStream is = new ByteArrayInputStream(decode);){
                GoogleCredentials googleCredentials = GoogleCredentials.fromStream((InputStream)is).createScoped(new String[]{CLOUD_OAUTH_SCOPE});
                return googleCredentials;
            }
        }
        if (gcpConfiguration.accessTokenEnabled() && this.securityIdentity.isResolvable() && !this.isAnonymous((SecurityIdentity)this.securityIdentity.get())) {
            for (Credential cred : ((SecurityIdentity)this.securityIdentity.get()).getCredentials()) {
                if (!(cred instanceof TokenCredential) || !"bearer".equals(((TokenCredential)cred).getType())) continue;
                return GoogleCredentials.create((AccessToken)new AccessToken(((TokenCredential)cred).getToken(), null)).createScoped(new String[]{CLOUD_OAUTH_SCOPE});
            }
        }
        return GoogleCredentials.getApplicationDefault().createScoped(new String[]{CLOUD_OAUTH_SCOPE});
    }

    private boolean isAnonymous(SecurityIdentity securityIdentity) {
        try {
            return securityIdentity.isAnonymous();
        }
        catch (ContextNotActiveException e) {
            return true;
        }
    }
}

