/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.googlecloudservices.logging.runtime;

import com.google.cloud.logging.LoggingHandler;
import com.google.cloud.logging.Severity;
import com.google.cloud.logging.Synchronicity;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import java.util.Map;
import java.util.Optional;

@ConfigRoot(name="google.cloud.logging", phase=ConfigPhase.RUN_TIME)
public class LoggingConfiguration {
    @ConfigItem
    public String defaultLog;
    @ConfigItem(defaultValue="true")
    public boolean enabled;
    @ConfigItem(defaultValue="TEXT")
    public LogFormat format;
    @ConfigItem
    public Optional<Synchronicity> synchronicity;
    @ConfigItem
    public Optional<ConfigLevel> flushLevel;
    @ConfigItem
    public Map<String, String> defaultLabel;
    @ConfigItem
    public ResourceConfig resource;
    @ConfigItem
    public GcpTracingConfig gcpTracing;
    @ConfigItem
    public StructuredConfig structured;
    @ConfigItem(defaultValue="CLOUD_LOGGING")
    public LoggingHandler.LogTarget logTarget;

    public static enum LogFormat {
        TEXT,
        JSON;

    }

    public static enum ConfigLevel {
        DEBUG(Severity.DEBUG),
        INFO(Severity.INFO),
        WARN(Severity.WARNING),
        ERROR(Severity.ERROR),
        FATAL(Severity.CRITICAL);

        private Severity severity;

        private ConfigLevel(Severity severity) {
            this.severity = severity;
        }

        public Severity getSeverity() {
            return this.severity;
        }
    }

    @ConfigGroup
    public static class ParametersConfig {
        @ConfigItem(defaultValue="true")
        public boolean included;
        @ConfigItem(defaultValue="parameters")
        public String fieldName;
    }

    @ConfigGroup
    public static class StackTraceConfig {
        @ConfigItem(defaultValue="true")
        public boolean included;
    }

    @ConfigGroup
    public static class MDCConfig {
        @ConfigItem(defaultValue="true")
        public boolean included;
        @ConfigItem(defaultValue="mdc")
        public String fieldName;
    }

    @ConfigGroup
    public static class ResourceConfig {
        @ConfigItem(defaultValue="global")
        public String type;
        @ConfigItem
        public Map<String, String> label;
    }

    @ConfigGroup
    public static class GcpTracingConfig {
        @ConfigItem(defaultValue="true")
        public boolean enabled;
        @ConfigItem
        public Optional<String> projectId;
    }

    @ConfigGroup
    public static class StructuredConfig {
        @ConfigItem
        public StackTraceConfig stackTrace;
        @ConfigItem
        public MDCConfig mdc;
        @ConfigItem
        public ParametersConfig parameters;
    }
}

