/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven;

import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContext;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContextConfig;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.devtools.project.BuildTool;
import io.quarkus.devtools.project.CodestartResourceLoadersBuilder;
import io.quarkus.devtools.project.JavaVersion;
import io.quarkus.devtools.project.QuarkusProject;
import io.quarkus.devtools.project.QuarkusProjectHelper;
import io.quarkus.devtools.project.buildfile.MavenProjectBuildFile;
import io.quarkus.maven.components.QuarkusWorkspaceProvider;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.platform.tools.ToolsUtils;
import io.quarkus.platform.tools.maven.MojoMessageWriter;
import io.quarkus.registry.ExtensionCatalogResolver;
import io.quarkus.registry.RegistryResolutionException;
import io.quarkus.registry.catalog.ExtensionCatalog;
import io.quarkus.registry.catalog.Platform;
import io.quarkus.registry.catalog.PlatformCatalog;
import io.quarkus.registry.catalog.PlatformRelease;
import io.quarkus.registry.catalog.PlatformStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;

public abstract class QuarkusProjectMojoBase
extends AbstractMojo {
    @Parameter(defaultValue="${project}")
    protected MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true)
    MavenSession session;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    protected RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    protected List<RemoteRepository> repos;
    @Parameter(property="bomGroupId", required=false)
    String bomGroupId;
    @Parameter(property="bomArtifactId", required=false)
    String bomArtifactId;
    @Parameter(property="bomVersion", required=false)
    String bomVersion;
    @Parameter(property="refresh", defaultValue="false")
    boolean refresh;
    @Component
    QuarkusWorkspaceProvider workspaceProvider;
    private List<ArtifactCoords> importedPlatforms;
    private Artifact projectArtifact;
    private MavenArtifactResolver artifactResolver;
    private ExtensionCatalogResolver catalogResolver;
    private MessageWriter log;

    public void execute() throws MojoExecutionException {
        QuarkusProject quarkusProject;
        this.validateParameters();
        Path projectDirPath = this.baseDir();
        BuildTool buildTool = QuarkusProject.resolveExistingProjectBuildTool((Path)projectDirPath);
        if (buildTool == null) {
            buildTool = BuildTool.MAVEN;
        }
        if (BuildTool.MAVEN.equals((Object)buildTool) && this.project.getFile() != null && this.bomVersion == null) {
            try {
                quarkusProject = MavenProjectBuildFile.getProject((Artifact)this.projectArtifact(), (Model)this.project.getOriginalModel(), (Path)this.baseDir(), (Properties)this.project.getModel().getProperties(), (MavenArtifactResolver)this.artifactResolver(), (ExtensionCatalogResolver)this.getExtensionCatalogResolver(), (MessageWriter)this.getMessageWriter(), null);
            }
            catch (RegistryResolutionException e) {
                throw new MojoExecutionException("Failed to initialize Quarkus Maven extension manager", (Exception)((Object)e));
            }
        } else {
            ExtensionCatalog extensionCatalog = this.resolveExtensionCatalog();
            List codestartsResourceLoader = CodestartResourceLoadersBuilder.codestartLoadersBuilder((MessageWriter)this.log).artifactResolver(this.artifactResolver()).catalog(extensionCatalog).build();
            quarkusProject = QuarkusProject.of((Path)this.baseDir(), (ExtensionCatalog)extensionCatalog, (List)codestartsResourceLoader, (MessageWriter)this.log, (BuildTool)buildTool, (JavaVersion)MavenProjectBuildFile.resolveJavaVersion((Properties)this.project.getModel().getProperties()));
        }
        this.doExecute(quarkusProject, this.getMessageWriter());
    }

    protected MessageWriter getMessageWriter() {
        return this.log == null ? (this.log = new MojoMessageWriter(this.getLog())) : this.log;
    }

    protected Path baseDir() {
        return this.project == null || this.project.getBasedir() == null ? Paths.get("", new String[0]).normalize().toAbsolutePath() : this.project.getBasedir().toPath();
    }

    private ExtensionCatalog resolveExtensionCatalog() throws MojoExecutionException {
        ExtensionCatalogResolver catalogResolver = this.getExtensionCatalogResolver();
        if (catalogResolver.hasRegistries()) {
            try {
                return catalogResolver.resolveExtensionCatalog(this.getImportedPlatforms());
            }
            catch (Exception e) {
                throw new MojoExecutionException("Failed to resolve the Quarkus extension catalog", e);
            }
        }
        return ToolsUtils.mergePlatforms(this.collectImportedPlatforms(), (MavenArtifactResolver)this.catalogArtifactResolver());
    }

    protected ExtensionCatalogResolver getExtensionCatalogResolver() throws MojoExecutionException {
        return this.catalogResolver == null ? (this.catalogResolver = this.initExtensionCatalogResolver()) : this.catalogResolver;
    }

    private ExtensionCatalogResolver initExtensionCatalogResolver() throws MojoExecutionException {
        ExtensionCatalogResolver catalogResolver;
        if (!QuarkusProjectHelper.isRegistryClientEnabled()) {
            return ExtensionCatalogResolver.empty();
        }
        try {
            catalogResolver = QuarkusProjectHelper.getCatalogResolver((MavenArtifactResolver)this.catalogArtifactResolver(), (MessageWriter)this.getMessageWriter());
            if (this.refresh) {
                catalogResolver.clearRegistryCache();
            }
        }
        catch (RegistryResolutionException e) {
            throw new MojoExecutionException("Failed to initialize Quarkus extension resolver", (Exception)((Object)e));
        }
        return catalogResolver;
    }

    protected List<ArtifactCoords> getImportedPlatforms() throws MojoExecutionException {
        if (this.importedPlatforms == null) {
            if (this.project.getFile() == null) {
                ArtifactCoords platformBom;
                if (this.bomGroupId == null && this.bomArtifactId == null && this.bomVersion == null) {
                    return List.of();
                }
                ExtensionCatalogResolver catalogResolver = this.getExtensionCatalogResolver();
                if (!catalogResolver.hasRegistries()) {
                    throw new MojoExecutionException("Couldn't resolve the Quarkus platform catalog since none of the Quarkus extension registries are available");
                }
                try {
                    platformBom = QuarkusProjectMojoBase.getSingleMatchingBom(this.bomGroupId, this.bomArtifactId, this.bomVersion, this.getExtensionCatalogResolver().resolvePlatformCatalog());
                }
                catch (RegistryResolutionException e) {
                    throw new MojoExecutionException("Failed to resolve the catalog of Quarkus platforms", (Exception)((Object)e));
                }
                if (platformBom == null && this.bomVersion != null) {
                    platformBom = ArtifactCoords.pom((String)(this.bomGroupId == null ? "io.quarkus.platform" : this.bomGroupId), (String)(this.bomArtifactId == null ? "quarkus-bom" : this.bomArtifactId), (String)this.bomVersion);
                }
                this.importedPlatforms = platformBom == null ? List.of() : List.of(platformBom);
                return this.importedPlatforms;
            }
            this.importedPlatforms = this.collectImportedPlatforms();
        }
        return this.importedPlatforms;
    }

    protected MavenArtifactResolver catalogArtifactResolver() throws MojoExecutionException {
        return this.artifactResolver();
    }

    protected MavenArtifactResolver artifactResolver() throws MojoExecutionException {
        return this.artifactResolver == null ? (this.artifactResolver = this.initArtifactResolver()) : this.artifactResolver;
    }

    protected MavenArtifactResolver initArtifactResolver() throws MojoExecutionException {
        BootstrapMavenContextConfig config = BootstrapMavenContext.config().setArtifactTransferLogging(this.getLog().isDebugEnabled()).setRemoteRepositoryManager(this.workspaceProvider.getRemoteRepositoryManager()).setRepositorySystem(this.workspaceProvider.getRepositorySystem()).setRemoteRepositories(this.repos).setWorkspaceDiscovery(false).setRepositorySystemSession(this.repoSession);
        return this.workspaceProvider.createArtifactResolver(config);
    }

    private List<ArtifactCoords> collectImportedPlatforms() {
        List constraints;
        ArrayList<ArtifactCoords> descriptors = new ArrayList<ArtifactCoords>(4);
        List list = constraints = this.project.getDependencyManagement() == null ? List.of() : this.project.getDependencyManagement().getDependencies();
        if (!constraints.isEmpty()) {
            MessageWriter log = this.getMessageWriter();
            for (Dependency d : constraints) {
                if (!"json".equals(d.getType()) || !d.getArtifactId().endsWith("-quarkus-platform-descriptor")) continue;
                ArtifactCoords a = ArtifactCoords.of((String)d.getGroupId(), (String)d.getArtifactId(), (String)d.getClassifier(), (String)d.getType(), (String)d.getVersion());
                descriptors.add(a);
                log.debug("Found platform descriptor %s", new Object[]{a});
            }
        }
        return descriptors;
    }

    protected void validateParameters() throws MojoExecutionException {
    }

    protected abstract void doExecute(QuarkusProject var1, MessageWriter var2) throws MojoExecutionException;

    private Artifact projectArtifact() {
        return this.projectArtifact == null ? (this.projectArtifact = new DefaultArtifact(this.project.getGroupId(), this.project.getArtifactId(), null, "pom", this.project.getVersion())) : this.projectArtifact;
    }

    static ArtifactCoords getSingleMatchingBom(String bomGroupId, String bomArtifactId, String bomVersion, PlatformCatalog platformCatalog) throws MojoExecutionException {
        if (bomGroupId == null && bomArtifactId == null && bomVersion == null) {
            return null;
        }
        ArtifactCoords platformBom = null;
        ArrayList<ArtifactCoords> matches = null;
        for (Platform p : platformCatalog.getPlatforms()) {
            if (bomGroupId != null && !p.getPlatformKey().equals(bomGroupId)) continue;
            for (PlatformStream s : p.getStreams()) {
                block9: for (PlatformRelease r : s.getReleases()) {
                    for (ArtifactCoords bom : r.getMemberBoms()) {
                        if (bomArtifactId != null && !bom.getArtifactId().equals(bomArtifactId) || bomVersion != null && !bom.getVersion().equals(bomVersion)) continue;
                        if (platformBom == null) {
                            platformBom = bom;
                            continue block9;
                        }
                        if (matches == null) {
                            matches = new ArrayList<ArtifactCoords>();
                            matches.add(platformBom);
                        }
                        matches.add(bom);
                        continue block9;
                    }
                }
            }
        }
        if (matches != null) {
            StringWriter buf = new StringWriter();
            buf.append("Multiple platforms were matching the requested platform BOM coordinates ");
            buf.append(bomGroupId == null ? "*" : bomGroupId).append(':');
            buf.append(bomArtifactId == null ? "*" : bomArtifactId).append(':');
            buf.append(bomVersion == null ? "*" : bomVersion).append(": ");
            try (BufferedWriter writer = new BufferedWriter(buf);){
                for (ArtifactCoords bom : matches) {
                    writer.newLine();
                    writer.append("- ").append(bom.toString());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new MojoExecutionException(buf.toString());
        }
        return platformBom;
    }
}

