/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.agroal.runtime;

import io.agroal.api.AgroalDataSource;
import io.quarkus.agroal.runtime.AgroalDataSourceSupport;
import io.quarkus.agroal.runtime.DataSources;
import io.quarkus.agroal.runtime.DataSourcesJdbcRuntimeConfig;
import io.quarkus.arc.ActiveResult;
import io.quarkus.arc.SyntheticCreationalContext;
import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.datasource.runtime.DataSourceRuntimeConfig;
import io.quarkus.datasource.runtime.DataSourcesRuntimeConfig;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;

@Recorder
public class AgroalRecorder {
    private final RuntimeValue<DataSourcesRuntimeConfig> runtimeConfig;
    private final RuntimeValue<DataSourcesJdbcRuntimeConfig> jdbcRuntimeConfig;

    @Inject
    public AgroalRecorder(RuntimeValue<DataSourcesRuntimeConfig> runtimeConfig, RuntimeValue<DataSourcesJdbcRuntimeConfig> jdbcRuntimeConfig) {
        this.runtimeConfig = runtimeConfig;
        this.jdbcRuntimeConfig = jdbcRuntimeConfig;
    }

    public Supplier<AgroalDataSourceSupport> dataSourceSupportSupplier(final AgroalDataSourceSupport agroalDataSourceSupport) {
        return new Supplier<AgroalDataSourceSupport>(){

            @Override
            public AgroalDataSourceSupport get() {
                return agroalDataSourceSupport;
            }
        };
    }

    public Supplier<ActiveResult> agroalDataSourceCheckActiveSupplier(final String dataSourceName) {
        return new Supplier<ActiveResult>(){

            @Override
            public ActiveResult get() {
                Optional active = ((DataSourceRuntimeConfig)((DataSourcesRuntimeConfig)AgroalRecorder.this.runtimeConfig.getValue()).dataSources().get(dataSourceName)).active();
                if (active.isPresent() && !((Boolean)active.get()).booleanValue()) {
                    return ActiveResult.inactive((String)DataSourceUtil.dataSourceInactiveReasonDeactivated((String)dataSourceName));
                }
                if (((DataSourcesJdbcRuntimeConfig)AgroalRecorder.this.jdbcRuntimeConfig.getValue()).dataSources().get(dataSourceName).jdbc().url().isEmpty()) {
                    return ActiveResult.inactive((String)DataSourceUtil.dataSourceInactiveReasonUrlMissing((String)dataSourceName, (String)"jdbc.url"));
                }
                return ActiveResult.active();
            }
        };
    }

    public Function<SyntheticCreationalContext<AgroalDataSource>, AgroalDataSource> agroalDataSourceSupplier(final String dataSourceName, DataSourcesRuntimeConfig dataSourcesRuntimeConfig) {
        return new Function<SyntheticCreationalContext<AgroalDataSource>, AgroalDataSource>(){

            @Override
            public AgroalDataSource apply(SyntheticCreationalContext<AgroalDataSource> context) {
                DataSources dataSources = (DataSources)context.getInjectedReference(DataSources.class, new Annotation[0]);
                return dataSources.createDataSource(dataSourceName);
            }
        };
    }
}

