/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.agroal.runtime.health;

import io.agroal.api.AgroalDataSource;
import io.quarkus.agroal.runtime.AgroalDataSourceSupport;
import io.quarkus.agroal.runtime.DataSources;
import io.quarkus.arc.Arc;
import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.datasource.runtime.DataSourceSupport;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;
import org.eclipse.microprofile.health.Readiness;

@Readiness
@ApplicationScoped
public class DataSourceHealthCheck
implements HealthCheck {
    @Inject
    Instance<DataSources> dataSources;
    private final Map<String, DataSource> checkedDataSources = new HashMap<String, DataSource>();

    @PostConstruct
    protected void init() {
        if (!this.dataSources.isResolvable()) {
            return;
        }
        DataSourceSupport support = (DataSourceSupport)Arc.container().instance(DataSourceSupport.class, new Annotation[0]).get();
        AgroalDataSourceSupport agroalSupport = (AgroalDataSourceSupport)Arc.container().instance(AgroalDataSourceSupport.class, new Annotation[0]).get();
        Set names = support.getConfiguredNames();
        Set excludedNames = support.getInactiveOrHealthCheckExcludedNames();
        for (String name : names) {
            AgroalDataSource ds;
            if (excludedNames.contains(name) || !agroalSupport.entries.containsKey(name) || (ds = ((DataSources)this.dataSources.get()).getDataSource(name)) == null) continue;
            this.checkedDataSources.put(name, (DataSource)ds);
        }
    }

    public HealthCheckResponse call() {
        HealthCheckResponseBuilder builder = HealthCheckResponse.named((String)"Database connections health check").up();
        for (Map.Entry<String, DataSource> dataSource : this.checkedDataSources.entrySet()) {
            String data;
            boolean isDefault = DataSourceUtil.isDefault((String)dataSource.getKey());
            AgroalDataSource ads = (AgroalDataSource)dataSource.getValue();
            String dsName = dataSource.getKey();
            try {
                boolean valid = ads.isHealthy(false);
                if (!valid) {
                    data = isDefault ? "validation check failed for the default DataSource" : "validation check failed for DataSource '" + dataSource.getKey() + "'";
                    builder.down().withData(dsName, data);
                    continue;
                }
                builder.withData(dsName, "UP");
            }
            catch (SQLException e) {
                data = isDefault ? "Unable to execute the validation check for the default DataSource: " : "Unable to execute the validation check for DataSource '" + dataSource.getKey() + "': ";
                builder.down().withData(dsName, data + e.getMessage());
            }
        }
        return builder.build();
    }
}

