/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment;

import io.quarkus.arc.SyntheticCreationalContext;
import io.quarkus.arc.deployment.BeanRegistrationPhaseBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.deployment.SyntheticBeansRuntimeInitBuildItem;
import io.quarkus.arc.processor.BeanConfigurator;
import io.quarkus.arc.processor.BeanConfiguratorBase;
import io.quarkus.arc.runtime.ArcRecorder;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Produce;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.runtime.util.HashUtil;
import jakarta.enterprise.inject.CreationException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;

public class SyntheticBeansProcessor {
    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    void initStatic(ArcRecorder recorder, List<SyntheticBeanBuildItem> syntheticBeans, BeanRegistrationPhaseBuildItem beanRegistration, BuildProducer<BeanRegistrationPhaseBuildItem.BeanConfiguratorBuildItem> configurators) {
        HashMap functionsMap = new HashMap();
        for (SyntheticBeanBuildItem bean : syntheticBeans) {
            if (!bean.hasRecorderInstance() || !bean.isStaticInit()) continue;
            this.configureSyntheticBean(recorder, functionsMap, beanRegistration, bean);
        }
        recorder.initStaticSupplierBeans(functionsMap);
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @Produce(value=SyntheticBeansRuntimeInitBuildItem.class)
    @BuildStep
    ServiceStartBuildItem initRuntime(ArcRecorder recorder, List<SyntheticBeanBuildItem> syntheticBeans, BeanRegistrationPhaseBuildItem beanRegistration, BuildProducer<BeanRegistrationPhaseBuildItem.BeanConfiguratorBuildItem> configurators) {
        HashMap functionsMap = new HashMap();
        for (SyntheticBeanBuildItem bean : syntheticBeans) {
            if (!bean.hasRecorderInstance() || bean.isStaticInit()) continue;
            this.configureSyntheticBean(recorder, functionsMap, beanRegistration, bean);
        }
        recorder.initRuntimeSupplierBeans(functionsMap);
        return new ServiceStartBuildItem("runtime-bean-init");
    }

    @BuildStep
    void initRegular(List<SyntheticBeanBuildItem> syntheticBeans, BeanRegistrationPhaseBuildItem beanRegistration, BuildProducer<BeanRegistrationPhaseBuildItem.BeanConfiguratorBuildItem> configurators) {
        for (SyntheticBeanBuildItem bean : syntheticBeans) {
            if (bean.hasRecorderInstance()) continue;
            this.configureSyntheticBean(null, null, beanRegistration, bean);
        }
    }

    private void configureSyntheticBean(ArcRecorder recorder, Map<String, Function<SyntheticCreationalContext<?>, ?>> functionsMap, BeanRegistrationPhaseBuildItem beanRegistration, SyntheticBeanBuildItem bean) {
        String name = this.createName(bean.configurator());
        if (bean.configurator().getRuntimeValue() != null) {
            functionsMap.put(name, recorder.createFunction(bean.configurator().getRuntimeValue()));
        } else if (bean.configurator().getSupplier() != null) {
            functionsMap.put(name, recorder.createFunction(bean.configurator().getSupplier()));
        } else if (bean.configurator().getFunction() != null) {
            functionsMap.put(name, bean.configurator().getFunction());
        } else if (bean.configurator().getRuntimeProxy() != null) {
            functionsMap.put(name, recorder.createFunction(bean.configurator().getRuntimeProxy()));
        }
        BeanConfigurator configurator = (BeanConfigurator)beanRegistration.getContext().configure(bean.configurator().getImplClazz()).read((BeanConfiguratorBase)bean.configurator());
        if (bean.hasRecorderInstance()) {
            configurator.creator(this.creator(name, bean));
        }
        configurator.done();
    }

    private String createName(SyntheticBeanBuildItem.ExtendedBeanConfigurator configurator) {
        return configurator.getImplClazz().toString().replace(".", "_") + "_" + HashUtil.sha1((String)(configurator.getTypes().toString() + configurator.getQualifiers().toString()));
    }

    private Consumer<MethodCreator> creator(final String name, final SyntheticBeanBuildItem bean) {
        return new Consumer<MethodCreator>(){

            @Override
            public void accept(MethodCreator m) {
                ResultHandle staticMap = m.readStaticField(FieldDescriptor.of(ArcRecorder.class, (String)"syntheticBeanProviders", Map.class));
                ResultHandle function = m.invokeInterfaceMethod(MethodDescriptor.ofMethod(Map.class, (String)"get", Object.class, (Class[])new Class[]{Object.class}), staticMap, new ResultHandle[]{m.load(name)});
                m.ifNull(function).trueBranch().throwException(CreationException.class, SyntheticBeansProcessor.this.createMessage(name, bean));
                ResultHandle result = m.invokeInterfaceMethod(MethodDescriptor.ofMethod(Function.class, (String)"apply", Object.class, (Class[])new Class[]{Object.class}), function, new ResultHandle[]{m.getMethodParam(0)});
                m.returnValue(result);
            }
        };
    }

    private String createMessage(String name, SyntheticBeanBuildItem bean) {
        StringBuilder builder = new StringBuilder();
        builder.append("Synthetic bean instance for ");
        builder.append(bean.configurator().getImplClazz());
        builder.append(" not initialized yet: ");
        builder.append(name);
        if (!bean.isStaticInit()) {
            builder.append("\n\t- a synthetic bean initialized during RUNTIME_INIT must not be accessed during STATIC_INIT");
            builder.append("\n\t- RUNTIME_INIT build steps that require access to synthetic beans initialized during RUNTIME_INIT should consume the SyntheticBeansRuntimeInitBuildItem");
        }
        return builder.toString();
    }
}

