/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.model;

import io.quarkus.bootstrap.model.JvmOption;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public abstract class MutableBaseJvmOption<T extends MutableBaseJvmOption<T>>
implements JvmOption,
Serializable {
    private static final String EMPTY_STR = "";
    private static final String PROPERTY_VALUE_SEPARATOR = "|";
    private String name;
    private Set<String> values = Set.of();

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Collection<String> getValues() {
        return this.values;
    }

    protected void setName(String name) {
        this.name = name;
    }

    public T addValue(String value) {
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        if (value.isBlank()) {
            throw new IllegalArgumentException("value is blank");
        }
        if (this.values.isEmpty()) {
            this.values = new HashSet<String>(1);
        }
        for (String v : value.split("\\|")) {
            this.values.add(v);
        }
        return (T)this;
    }

    protected abstract String getQuarkusExtensionPropertyPrefix();

    @Override
    public void addToQuarkusExtensionProperties(Properties props) {
        props.setProperty(this.getQuarkusExtensionPropertyPrefix() + this.name, this.toPropertyValue());
    }

    protected String toPropertyValue() {
        if (this.values.isEmpty()) {
            return EMPTY_STR;
        }
        Iterator<String> i = this.values.iterator();
        if (this.values.size() == 1) {
            return i.next();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(i.next());
        while (i.hasNext()) {
            sb.append(PROPERTY_VALUE_SEPARATOR).append(i.next());
        }
        return sb.toString();
    }

    public String toString() {
        return this.name + "=" + this.values;
    }
}

