/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cache.deployment;

import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.Transformation;
import io.quarkus.cache.deployment.CacheDeploymentConstants;
import io.quarkus.cache.runtime.CacheInvalidateAllInterceptorBinding;
import io.quarkus.cache.runtime.CacheInvalidateInterceptorBinding;
import io.quarkus.cache.runtime.CacheResultInterceptorBinding;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;

public class CacheAnnotationsTransformer
implements AnnotationsTransformer {
    public boolean appliesTo(AnnotationTarget.Kind kind) {
        return AnnotationTarget.Kind.METHOD == kind;
    }

    public void transform(AnnotationsTransformer.TransformationContext context) {
        MethodInfo method = context.getTarget().asMethod();
        ArrayList<AnnotationInstance> interceptorBindings = new ArrayList<AnnotationInstance>();
        for (AnnotationInstance annotation : method.annotations()) {
            AnnotationTarget target = annotation.target();
            if (target.kind() != AnnotationTarget.Kind.METHOD) continue;
            if (CacheDeploymentConstants.CACHE_INVALIDATE_ALL.equals((Object)annotation.name())) {
                interceptorBindings.add(this.createCacheInvalidateAllBinding(annotation, target));
                continue;
            }
            if (CacheDeploymentConstants.CACHE_INVALIDATE_ALL_LIST.equals((Object)annotation.name())) {
                for (AnnotationInstance nestedAnnotation : annotation.value("value").asNestedArray()) {
                    interceptorBindings.add(this.createCacheInvalidateAllBinding(nestedAnnotation, target));
                }
                continue;
            }
            if (CacheDeploymentConstants.CACHE_INVALIDATE.equals((Object)annotation.name())) {
                interceptorBindings.add(this.createCacheInvalidateBinding(method, annotation, target));
                continue;
            }
            if (CacheDeploymentConstants.CACHE_INVALIDATE_LIST.equals((Object)annotation.name())) {
                for (AnnotationInstance nestedAnnotation : annotation.value("value").asNestedArray()) {
                    interceptorBindings.add(this.createCacheInvalidateBinding(method, nestedAnnotation, target));
                }
                continue;
            }
            if (!CacheDeploymentConstants.CACHE_RESULT.equals((Object)annotation.name())) continue;
            interceptorBindings.add(this.createCacheResultBinding(method, annotation, target));
        }
        ((Transformation)context.transform().addAll(interceptorBindings)).done();
    }

    private AnnotationInstance createCacheInvalidateAllBinding(AnnotationInstance annotation, AnnotationTarget target) {
        return this.createBinding(CacheInvalidateAllInterceptorBinding.class, target, this.getCacheName(annotation));
    }

    private AnnotationInstance createCacheInvalidateBinding(MethodInfo method, AnnotationInstance annotation, AnnotationTarget target) {
        ArrayList<AnnotationValue> parameters = new ArrayList<AnnotationValue>();
        parameters.add(this.getCacheName(annotation));
        this.findCacheKeyParameters(method).ifPresent(parameters::add);
        return this.createBinding(CacheInvalidateInterceptorBinding.class, target, this.toArray(parameters));
    }

    private AnnotationInstance createCacheResultBinding(MethodInfo method, AnnotationInstance annotation, AnnotationTarget target) {
        ArrayList<AnnotationValue> parameters = new ArrayList<AnnotationValue>();
        parameters.add(this.getCacheName(annotation));
        this.findCacheKeyParameters(method).ifPresent(parameters::add);
        this.findLockTimeout(annotation).ifPresent(parameters::add);
        return this.createBinding(CacheResultInterceptorBinding.class, target, this.toArray(parameters));
    }

    private AnnotationInstance createBinding(Class<?> bindingClass, AnnotationTarget target, AnnotationValue ... values) {
        return AnnotationInstance.create((DotName)DotName.createSimple((String)bindingClass.getName()), (AnnotationTarget)target, (AnnotationValue[])values);
    }

    private AnnotationValue getCacheName(AnnotationInstance annotation) {
        return annotation.value("cacheName");
    }

    private Optional<AnnotationValue> findCacheKeyParameters(MethodInfo method) {
        ArrayList<AnnotationValue> parameters = new ArrayList<AnnotationValue>();
        for (AnnotationInstance annotation : method.annotations()) {
            if (annotation.target().kind() != AnnotationTarget.Kind.METHOD_PARAMETER || !CacheDeploymentConstants.CACHE_KEY.equals((Object)annotation.name())) continue;
            parameters.add(AnnotationValue.createShortValue((String)"", (short)annotation.target().asMethodParameter().position()));
        }
        if (parameters.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(AnnotationValue.createArrayValue((String)"cacheKeyParameterPositions", (AnnotationValue[])this.toArray(parameters)));
    }

    private Optional<AnnotationValue> findLockTimeout(AnnotationInstance annotation) {
        return Optional.ofNullable(annotation.value("lockTimeout"));
    }

    private AnnotationValue[] toArray(List<AnnotationValue> parameters) {
        return parameters.toArray(new AnnotationValue[0]);
    }
}

