/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.pkg.steps;

import io.quarkus.deployment.pkg.NativeConfig;
import io.quarkus.deployment.pkg.steps.NativeImageBuildContainerRunner;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.util.List;

public class NativeImageBuildRemoteContainerRunner
extends NativeImageBuildContainerRunner {
    private final String nativeImageName;
    private String containerId;

    public NativeImageBuildRemoteContainerRunner(NativeConfig nativeConfig, Path outputDir, String nativeImageName) {
        super(nativeConfig, outputDir);
        this.nativeImageName = nativeImageName;
    }

    @Override
    protected void preBuild(List<String> buildArgs) throws InterruptedException, IOException {
        List<String> containerRuntimeArgs = this.getContainerRuntimeBuildArgs();
        String[] createContainerCommand = this.buildCommand("create", containerRuntimeArgs, buildArgs);
        Process createContainerProcess = new ProcessBuilder(createContainerCommand).start();
        createContainerProcess.waitFor();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(createContainerProcess.getInputStream()));){
            this.containerId = reader.readLine();
        }
        String[] copyCommand = new String[]{this.containerRuntime.getExecutableName(), "cp", this.outputPath + "/.", this.containerId + ":" + "/project"};
        Process copyProcess = new ProcessBuilder(copyCommand).start();
        copyProcess.waitFor();
        super.preBuild(buildArgs);
    }

    @Override
    protected String[] getBuildCommand(List<String> args) {
        return new String[]{this.containerRuntime.getExecutableName(), "start", "--attach", this.containerId};
    }

    @Override
    protected void postBuild() throws InterruptedException, IOException {
        String[] copyCommand = new String[]{this.containerRuntime.getExecutableName(), "cp", this.containerId + ":" + "/project" + "/" + this.nativeImageName, this.outputPath};
        Process copyProcess = new ProcessBuilder(copyCommand).start();
        copyProcess.waitFor();
        String[] removeCommand = new String[]{this.containerRuntime.getExecutableName(), "container", "rm", "--volumes", this.containerId};
        Process removeProcess = new ProcessBuilder(removeCommand).start();
        removeProcess.waitFor();
    }
}

