/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.GeneratedNativeImageClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.JPMSExportBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedPackageBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeReinitializedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.UnsafeAccessedFieldBuildItem;
import io.quarkus.deployment.pkg.NativeConfig;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.CatchBlockCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.TryBlock;
import io.quarkus.runtime.LocalesBuildTimeConfig;
import io.quarkus.runtime.graal.GraalVM;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Locale;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeClassInitialization;
import org.graalvm.nativeimage.hosted.RuntimeSystemProperties;

public class NativeImageFeatureStep {
    public static final String GRAAL_FEATURE = "io.quarkus.runner.Feature";
    private static final MethodDescriptor IMAGE_SINGLETONS_LOOKUP = MethodDescriptor.ofMethod(ImageSingletons.class, (String)"lookup", Object.class, (Class[])new Class[]{Class.class});
    private static final MethodDescriptor BUILD_TIME_INITIALIZATION = MethodDescriptor.ofMethod(RuntimeClassInitialization.class, (String)"initializeAtBuildTime", Void.TYPE, (Class[])new Class[]{String[].class});
    private static final MethodDescriptor REGISTER_RUNTIME_SYSTEM_PROPERTIES = MethodDescriptor.ofMethod(RuntimeSystemProperties.class, (String)"register", Void.TYPE, (Class[])new Class[]{String.class, String.class});
    private static final MethodDescriptor GRAALVM_VERSION_GET_CURRENT = MethodDescriptor.ofMethod(GraalVM.Version.class, (String)"getCurrent", GraalVM.Version.class, (Class[])new Class[0]);
    private static final MethodDescriptor GRAALVM_VERSION_COMPARE_TO = MethodDescriptor.ofMethod(GraalVM.Version.class, (String)"compareTo", Integer.TYPE, (Class[])new Class[]{int[].class});
    private static final MethodDescriptor INITIALIZE_CLASSES_AT_RUN_TIME = MethodDescriptor.ofMethod(RuntimeClassInitialization.class, (String)"initializeAtRunTime", Void.TYPE, (Class[])new Class[]{Class[].class});
    private static final MethodDescriptor INITIALIZE_PACKAGES_AT_RUN_TIME = MethodDescriptor.ofMethod(RuntimeClassInitialization.class, (String)"initializeAtRunTime", Void.TYPE, (Class[])new Class[]{String[].class});
    public static final String RUNTIME_CLASS_INITIALIZATION_SUPPORT = "org.graalvm.nativeimage.impl.RuntimeClassInitializationSupport";
    private static final MethodDescriptor RERUN_INITIALIZATION = MethodDescriptor.ofMethod((Object)"org.graalvm.nativeimage.impl.RuntimeClassInitializationSupport", (String)"rerunInitialization", Void.TYPE, (Object[])new Object[]{Class.class, String.class});
    static final String BEFORE_ANALYSIS_ACCESS = Feature.BeforeAnalysisAccess.class.getName();

    @BuildStep
    void addExportsToNativeImage(BuildProducer<JPMSExportBuildItem> features) {
        features.produce(new JPMSExportBuildItem("org.graalvm.sdk", "org.graalvm.nativeimage.impl", null, GraalVM.Version.VERSION_23_1_0));
        features.produce(new JPMSExportBuildItem("org.graalvm.nativeimage", "org.graalvm.nativeimage.impl", GraalVM.Version.VERSION_23_1_0));
    }

    @BuildStep
    void generateFeature(final BuildProducer<GeneratedNativeImageClassBuildItem> nativeImageClass, List<RuntimeInitializedClassBuildItem> runtimeInitializedClassBuildItems, List<RuntimeInitializedPackageBuildItem> runtimeInitializedPackageBuildItems, List<RuntimeReinitializedClassBuildItem> runtimeReinitializedClassBuildItems, List<UnsafeAccessedFieldBuildItem> unsafeAccessedFields, NativeConfig nativeConfig, LocalesBuildTimeConfig localesBuildTimeConfig) {
        CatchBlockCreator cc;
        ResultHandle cl;
        ResultHandle thisClass;
        ClassCreator file = new ClassCreator(new ClassOutput(){

            public void write(String s, byte[] bytes) {
                nativeImageClass.produce(new GeneratedNativeImageClassBuildItem(s, bytes));
            }
        }, GRAAL_FEATURE, null, Object.class.getName(), new String[]{Feature.class.getName()});
        MethodCreator getDescription = file.getMethodCreator("getDescription", String.class, new Class[0]);
        getDescription.returnValue(getDescription.load("Auto-generated class by Quarkus from the existing extensions"));
        MethodCreator beforeAn = file.getMethodCreator("beforeAnalysis", "V", new String[]{BEFORE_ANALYSIS_ACCESS});
        TryBlock overallCatch = beforeAn.tryBlock();
        overallCatch.invokeStaticMethod(BUILD_TIME_INITIALIZATION, new ResultHandle[]{overallCatch.marshalAsArray(String.class, new ResultHandle[]{overallCatch.load("")})});
        if (nativeConfig.userLanguage().isPresent()) {
            overallCatch.invokeStaticMethod(REGISTER_RUNTIME_SYSTEM_PROPERTIES, new ResultHandle[]{overallCatch.load("user.language"), overallCatch.load(nativeConfig.userLanguage().get())});
            if (nativeConfig.userCountry().isPresent()) {
                overallCatch.invokeStaticMethod(REGISTER_RUNTIME_SYSTEM_PROPERTIES, new ResultHandle[]{overallCatch.load("user.country"), overallCatch.load(nativeConfig.userCountry().get())});
            }
        } else if (localesBuildTimeConfig.defaultLocale.isPresent()) {
            overallCatch.invokeStaticMethod(REGISTER_RUNTIME_SYSTEM_PROPERTIES, new ResultHandle[]{overallCatch.load("user.language"), overallCatch.load(((Locale)localesBuildTimeConfig.defaultLocale.get()).getLanguage())});
            overallCatch.invokeStaticMethod(REGISTER_RUNTIME_SYSTEM_PROPERTIES, new ResultHandle[]{overallCatch.load("user.country"), overallCatch.load(((Locale)localesBuildTimeConfig.defaultLocale.get()).getCountry())});
        } else {
            ResultHandle graalVMVersion = overallCatch.invokeStaticMethod(GRAALVM_VERSION_GET_CURRENT, new ResultHandle[0]);
            BranchResult graalVm24_2Test = overallCatch.ifGreaterEqualZero(overallCatch.invokeVirtualMethod(GRAALVM_VERSION_COMPARE_TO, graalVMVersion, new ResultHandle[]{overallCatch.marshalAsArray(Integer.TYPE, new ResultHandle[]{overallCatch.load(24), overallCatch.load(2)})}));
            try (BytecodeCreator greaterEqual24_2 = graalVm24_2Test.trueBranch();){
                greaterEqual24_2.invokeStaticMethod(REGISTER_RUNTIME_SYSTEM_PROPERTIES, new ResultHandle[]{greaterEqual24_2.load("user.language"), greaterEqual24_2.load("en")});
                greaterEqual24_2.invokeStaticMethod(REGISTER_RUNTIME_SYSTEM_PROPERTIES, new ResultHandle[]{greaterEqual24_2.load("user.country"), greaterEqual24_2.load("US")});
            }
        }
        if (!runtimeInitializedClassBuildItems.isEmpty()) {
            MethodCreator runtimeInitializedClasses = (MethodCreator)file.getMethodCreator("runtimeInitializedClasses", Class[].class, new Class[0]).setModifiers(10);
            thisClass = runtimeInitializedClasses.loadClassFromTCCL(GRAAL_FEATURE);
            cl = runtimeInitializedClasses.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getClassLoader", ClassLoader.class, (Class[])new Class[0]), thisClass, new ResultHandle[0]);
            ResultHandle classesArray = runtimeInitializedClasses.newArray(Class.class, runtimeInitializedClasses.load(runtimeInitializedClassBuildItems.size()));
            for (int i = 0; i < runtimeInitializedClassBuildItems.size(); ++i) {
                TryBlock tc = runtimeInitializedClasses.tryBlock();
                ResultHandle clazz = tc.invokeStaticMethod(MethodDescriptor.ofMethod(Class.class, (String)"forName", Class.class, (Class[])new Class[]{String.class, Boolean.TYPE, ClassLoader.class}), new ResultHandle[]{tc.load(runtimeInitializedClassBuildItems.get(i).getClassName()), tc.load(false), cl});
                tc.writeArrayValue(classesArray, i, clazz);
                CatchBlockCreator cc2 = tc.addCatch(Throwable.class);
                cc2.invokeVirtualMethod(MethodDescriptor.ofMethod(Throwable.class, (String)"printStackTrace", Void.TYPE, (Class[])new Class[0]), cc2.getCaughtException(), new ResultHandle[0]);
            }
            runtimeInitializedClasses.returnValue(classesArray);
            ResultHandle classes = overallCatch.invokeStaticMethod(runtimeInitializedClasses.getMethodDescriptor(), new ResultHandle[0]);
            overallCatch.invokeStaticMethod(INITIALIZE_CLASSES_AT_RUN_TIME, new ResultHandle[]{classes});
        }
        if (!runtimeInitializedPackageBuildItems.isEmpty()) {
            MethodCreator runtimeInitializedPackages = (MethodCreator)file.getMethodCreator("runtimeInitializedPackages", String[].class, new Class[0]).setModifiers(10);
            ResultHandle packagesArray = runtimeInitializedPackages.newArray(String.class, runtimeInitializedPackages.load(runtimeInitializedPackageBuildItems.size()));
            for (int i = 0; i < runtimeInitializedPackageBuildItems.size(); ++i) {
                TryBlock tc = runtimeInitializedPackages.tryBlock();
                ResultHandle pkg = tc.load(runtimeInitializedPackageBuildItems.get(i).getPackageName());
                tc.writeArrayValue(packagesArray, i, pkg);
                CatchBlockCreator cc3 = tc.addCatch(Throwable.class);
                cc3.invokeVirtualMethod(MethodDescriptor.ofMethod(Throwable.class, (String)"printStackTrace", Void.TYPE, (Class[])new Class[0]), cc3.getCaughtException(), new ResultHandle[0]);
            }
            runtimeInitializedPackages.returnValue(packagesArray);
            ResultHandle packages = overallCatch.invokeStaticMethod(runtimeInitializedPackages.getMethodDescriptor(), new ResultHandle[0]);
            overallCatch.invokeStaticMethod(INITIALIZE_PACKAGES_AT_RUN_TIME, new ResultHandle[]{packages});
        }
        if (!runtimeReinitializedClassBuildItems.isEmpty()) {
            MethodCreator runtimeReinitializedClasses = (MethodCreator)file.getMethodCreator("runtimeReinitializedClasses", Void.TYPE, new Class[0]).setModifiers(10);
            thisClass = runtimeReinitializedClasses.loadClassFromTCCL(GRAAL_FEATURE);
            cl = runtimeReinitializedClasses.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getClassLoader", ClassLoader.class, (Class[])new Class[0]), thisClass, new ResultHandle[0]);
            ResultHandle quarkus = runtimeReinitializedClasses.load("Quarkus");
            ResultHandle imageSingleton = runtimeReinitializedClasses.invokeStaticMethod(IMAGE_SINGLETONS_LOOKUP, new ResultHandle[]{runtimeReinitializedClasses.loadClassFromTCCL(RUNTIME_CLASS_INITIALIZATION_SUPPORT)});
            for (RuntimeReinitializedClassBuildItem runtimeReinitializedClass : runtimeReinitializedClassBuildItems) {
                TryBlock tc = runtimeReinitializedClasses.tryBlock();
                ResultHandle clazz = tc.invokeStaticMethod(MethodDescriptor.ofMethod(Class.class, (String)"forName", Class.class, (Class[])new Class[]{String.class, Boolean.TYPE, ClassLoader.class}), new ResultHandle[]{tc.load(runtimeReinitializedClass.getClassName()), tc.load(false), cl});
                tc.invokeInterfaceMethod(RERUN_INITIALIZATION, imageSingleton, new ResultHandle[]{clazz, quarkus});
                cc = tc.addCatch(Throwable.class);
                cc.invokeVirtualMethod(MethodDescriptor.ofMethod(Throwable.class, (String)"printStackTrace", Void.TYPE, (Class[])new Class[0]), cc.getCaughtException(), new ResultHandle[0]);
            }
            runtimeReinitializedClasses.returnVoid();
            overallCatch.invokeStaticMethod(runtimeReinitializedClasses.getMethodDescriptor(), new ResultHandle[0]);
        }
        if (!unsafeAccessedFields.isEmpty()) {
            ResultHandle beforeAnalysisParam = beforeAn.getMethodParam(0);
            MethodCreator registerAsUnsafeAccessed = (MethodCreator)file.getMethodCreator("registerAsUnsafeAccessed", Void.TYPE, new Class[]{Feature.BeforeAnalysisAccess.class}).setModifiers(10);
            ResultHandle thisClass2 = registerAsUnsafeAccessed.loadClassFromTCCL(GRAAL_FEATURE);
            ResultHandle cl2 = registerAsUnsafeAccessed.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getClassLoader", ClassLoader.class, (Class[])new Class[0]), thisClass2, new ResultHandle[0]);
            for (UnsafeAccessedFieldBuildItem unsafeAccessedField : unsafeAccessedFields) {
                TryBlock tc = registerAsUnsafeAccessed.tryBlock();
                ResultHandle declaringClassHandle = tc.invokeStaticMethod(MethodDescriptor.ofMethod(Class.class, (String)"forName", Class.class, (Class[])new Class[]{String.class, Boolean.TYPE, ClassLoader.class}), new ResultHandle[]{tc.load(unsafeAccessedField.getDeclaringClass()), tc.load(false), cl2});
                ResultHandle fieldHandle = tc.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getDeclaredField", Field.class, (Class[])new Class[]{String.class}), declaringClassHandle, new ResultHandle[]{tc.load(unsafeAccessedField.getFieldName())});
                tc.invokeInterfaceMethod(MethodDescriptor.ofMethod(Feature.BeforeAnalysisAccess.class, (String)"registerAsUnsafeAccessed", Void.TYPE, (Class[])new Class[]{Field.class}), registerAsUnsafeAccessed.getMethodParam(0), new ResultHandle[]{fieldHandle});
                cc = tc.addCatch(Throwable.class);
                cc.invokeVirtualMethod(MethodDescriptor.ofMethod(Throwable.class, (String)"printStackTrace", Void.TYPE, (Class[])new Class[0]), cc.getCaughtException(), new ResultHandle[0]);
            }
            registerAsUnsafeAccessed.returnVoid();
            overallCatch.invokeStaticMethod(registerAsUnsafeAccessed.getMethodDescriptor(), new ResultHandle[]{beforeAnalysisParam});
        }
        CatchBlockCreator print = overallCatch.addCatch(Throwable.class);
        print.invokeVirtualMethod(MethodDescriptor.ofMethod(Throwable.class, (String)"printStackTrace", Void.TYPE, (Class[])new Class[0]), print.getCaughtException(), new ResultHandle[0]);
        beforeAn.loadClassFromTCCL("io.quarkus.runner.ApplicationImpl");
        beforeAn.returnValue(null);
        file.close();
    }
}

