/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.builditem.nativeimage;

import io.quarkus.builder.item.MultiBuildItem;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import org.jboss.jandex.MethodInfo;

public final class ReflectiveMethodBuildItem
extends MultiBuildItem {
    final String declaringClass;
    final String name;
    final String[] params;

    public ReflectiveMethodBuildItem(MethodInfo methodInfo) {
        String[] params = new String[methodInfo.parametersCount()];
        for (int i = 0; i < params.length; ++i) {
            params[i] = methodInfo.parameterType(i).name().toString();
        }
        this.name = methodInfo.name();
        this.params = params;
        this.declaringClass = methodInfo.declaringClass().name().toString();
    }

    public ReflectiveMethodBuildItem(Method method) {
        this.params = new String[method.getParameterCount()];
        if (method.getParameterCount() > 0) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            for (int i = 0; i < this.params.length; ++i) {
                this.params[i] = parameterTypes[i].getName();
            }
        }
        this.name = method.getName();
        this.declaringClass = method.getDeclaringClass().getName();
    }

    public ReflectiveMethodBuildItem(String declaringClass, String name, String ... params) {
        this.declaringClass = declaringClass;
        this.name = name;
        this.params = params;
    }

    public ReflectiveMethodBuildItem(String declaringClass, String name, Class<?> ... params) {
        this.declaringClass = declaringClass;
        this.name = name;
        this.params = new String[params.length];
        for (int i = 0; i < params.length; ++i) {
            this.params[i] = params[i].getName();
        }
    }

    public String getName() {
        return this.name;
    }

    public String[] getParams() {
        return this.params;
    }

    public String getDeclaringClass() {
        return this.declaringClass;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ReflectiveMethodBuildItem that = (ReflectiveMethodBuildItem)((Object)o);
        return Objects.equals(this.declaringClass, that.declaringClass) && Objects.equals(this.name, that.name) && Arrays.equals(this.params, that.params);
    }

    public int hashCode() {
        int result = Objects.hash(this.declaringClass, this.name);
        result = 31 * result + Arrays.hashCode(this.params);
        return result;
    }
}

