/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.pkg.steps;

import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.pkg.NativeConfig;
import io.quarkus.deployment.pkg.builditem.ArtifactResultBuildItem;
import io.quarkus.deployment.pkg.builditem.NativeImageBuildItem;
import io.quarkus.deployment.pkg.builditem.NativeImageRunnerBuildItem;
import io.quarkus.deployment.pkg.builditem.UpxCompressedBuildItem;
import io.quarkus.deployment.pkg.steps.LinuxIDUtil;
import io.quarkus.deployment.util.ContainerRuntimeUtil;
import io.quarkus.deployment.util.FileUtil;
import io.quarkus.deployment.util.ProcessUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.jboss.logging.Logger;

public class UpxCompressionBuildStep {
    private static final Logger log = Logger.getLogger(UpxCompressionBuildStep.class);
    private static final String PATH = "PATH";

    public void compress(NativeConfig nativeConfig, NativeImageRunnerBuildItem nativeImageRunner, NativeImageBuildItem image, BuildProducer<UpxCompressedBuildItem> upxCompressedProducer, BuildProducer<ArtifactResultBuildItem> artifactResultProducer) {
        if (nativeConfig.compression().level().isEmpty()) {
            log.debug((Object)"UPX compression disabled");
            return;
        }
        String effectiveBuilderImage = nativeConfig.builderImage().getEffectiveImage();
        Optional<File> upxPathFromSystem = this.getUpxFromSystem();
        if (upxPathFromSystem.isPresent()) {
            log.debug((Object)"Running UPX from system path");
            if (!this.runUpxFromHost(upxPathFromSystem.get(), image.getPath().toFile(), nativeConfig)) {
                throw new IllegalStateException("Unable to compress the native executable");
            }
        } else {
            if (nativeConfig.remoteContainerBuild()) {
                log.errorf("Compression of native executables is not yet implemented for remote container builds.", new Object[0]);
                throw new IllegalStateException("Unable to compress the native executable: Compression of native executables is not yet supported for remote container builds");
            }
            if (nativeImageRunner.isContainerBuild()) {
                log.infof("Running UPX from a container using the builder image: " + effectiveBuilderImage, new Object[0]);
                if (!this.runUpxInContainer(image, nativeConfig, effectiveBuilderImage)) {
                    throw new IllegalStateException("Unable to compress the native executable");
                }
            } else {
                log.errorf("Unable to compress the native executable. Either install `upx` from https://upx.github.io/ on your machine, or enable in-container build using `-Dquarkus.native.container-build=true`.", new Object[0]);
                throw new IllegalStateException("Unable to compress the native executable: `upx` not available");
            }
        }
        log.infof("Native executable compressed: %s", (Object)image.getPath().toFile().getAbsolutePath());
        upxCompressedProducer.produce(new UpxCompressedBuildItem());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runUpxFromHost(File upx, File executable, NativeConfig nativeConfig) {
        List extraArgs = nativeConfig.compression().additionalArgs().orElse(Collections.emptyList());
        List<String> args = Stream.of(Stream.of(upx.getAbsolutePath()), nativeConfig.compression().level().stream().mapToObj(this::getCompressionLevel), extraArgs.stream(), Stream.of(executable.getAbsolutePath())).flatMap(Function.identity()).collect(Collectors.toList());
        log.infof("Executing %s", (Object)String.join((CharSequence)" ", args));
        ProcessBuilder processBuilder = new ProcessBuilder(args).directory(executable.getAbsoluteFile().getParentFile()).redirectOutput(ProcessBuilder.Redirect.PIPE).redirectError(ProcessBuilder.Redirect.PIPE);
        Process process = null;
        try {
            process = processBuilder.start();
            ProcessUtil.streamOutputToSysOut(process);
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                log.errorf("Command: " + String.join((CharSequence)" ", args) + " failed with exit code " + exitCode, new Object[0]);
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.errorf("Command: " + String.join((CharSequence)" ", args) + " failed", (Object)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runUpxInContainer(NativeImageBuildItem nativeImage, NativeConfig nativeConfig, String effectiveBuilderImage) {
        List extraArgs = nativeConfig.compression().additionalArgs().orElse(Collections.emptyList());
        ArrayList<String> commandLine = new ArrayList<String>();
        ContainerRuntimeUtil.ContainerRuntime containerRuntime = ContainerRuntimeUtil.detectContainerRuntime();
        commandLine.add(containerRuntime.getExecutableName());
        commandLine.add("run");
        commandLine.add("--env");
        commandLine.add("LANG=C");
        commandLine.add("--rm");
        commandLine.add("--entrypoint=upx");
        String containerName = "upx-" + RandomStringUtils.random((int)5, (boolean)true, (boolean)false);
        commandLine.add("--name");
        commandLine.add(containerName);
        String volumeOutputPath = nativeImage.getPath().toFile().getParentFile().getAbsolutePath();
        if (SystemUtils.IS_OS_WINDOWS) {
            volumeOutputPath = FileUtil.translateToVolumePath(volumeOutputPath);
        } else if (SystemUtils.IS_OS_LINUX) {
            String uid = LinuxIDUtil.getLinuxID("-ur");
            String gid = LinuxIDUtil.getLinuxID("-gr");
            if (uid != null && gid != null && !uid.isEmpty() && !gid.isEmpty()) {
                Collections.addAll(commandLine, "--user", uid + ":" + gid);
                if (containerRuntime.isPodman() && containerRuntime.isRootless()) {
                    commandLine.add("--userns=keep-id");
                }
            }
        }
        Collections.addAll(commandLine, "-v", volumeOutputPath + ":/project:z");
        commandLine.add(effectiveBuilderImage);
        if (nativeConfig.compression().level().isPresent()) {
            commandLine.add(this.getCompressionLevel(nativeConfig.compression().level().getAsInt()));
        }
        commandLine.addAll(extraArgs);
        commandLine.add(nativeImage.getPath().toFile().getName());
        log.infof("Compress native executable using: %s", (Object)String.join((CharSequence)" ", commandLine));
        ProcessBuilder processBuilder = new ProcessBuilder(commandLine).redirectOutput(ProcessBuilder.Redirect.PIPE).redirectError(ProcessBuilder.Redirect.PIPE);
        Process process = null;
        try {
            process = processBuilder.start();
            ProcessUtil.streamOutputToSysOut(process);
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                if (exitCode == 127) {
                    log.errorf("Command: %s failed because the builder image does not provide the `upx` executable", (Object)String.join((CharSequence)" ", commandLine));
                } else {
                    log.errorf("Command: %s failed with exit code %d", (Object)String.join((CharSequence)" ", commandLine), (Object)exitCode);
                }
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.errorf("Command: " + String.join((CharSequence)" ", commandLine) + " failed", (Object)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
    }

    private String getCompressionLevel(int level) {
        if (level == 10) {
            return "--best";
        }
        if (level > 0 && level < 10) {
            return "-" + level;
        }
        throw new IllegalArgumentException("Invalid compression level, " + level + " is not in [1, 10]");
    }

    private Optional<File> getUpxFromSystem() {
        String exec = UpxCompressionBuildStep.getUpxExecutableName();
        String systemPath = System.getenv(PATH);
        if (systemPath != null) {
            String[] pathDirs;
            for (String pathDir : pathDirs = systemPath.split(File.pathSeparator)) {
                File file;
                File dir = new File(pathDir);
                if (!dir.isDirectory() || !(file = new File(dir, exec)).exists()) continue;
                return Optional.of(file);
            }
        }
        return Optional.empty();
    }

    private static String getUpxExecutableName() {
        return SystemUtils.IS_OS_WINDOWS ? "upx.exe" : "upx";
    }
}

