/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.configuration;

import io.quarkus.runtime.configuration.NameIterator;
import io.smallrye.config.PropertyName;
import java.util.HashMap;
import java.util.Set;

public class PropertiesUtil {
    private PropertiesUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static boolean isPropertyInRoots(String property, Set<String> roots) {
        for (String root : roots) {
            if (!PropertiesUtil.isPropertyInRoot(property, root)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPropertyInRoot(String property, String root) {
        if (property.length() < root.length()) {
            return false;
        }
        if (property.equals(root)) {
            return true;
        }
        if (property.length() == root.length()) {
            return false;
        }
        char c = property.charAt(root.length());
        if (c == '.' || c == '[') {
            return property.startsWith(root);
        }
        return false;
    }

    public static boolean isPropertyQuarkusCompoundName(NameIterator propertyName) {
        return propertyName.getName().startsWith("\"quarkus.");
    }

    public static Set<PropertyName> toPropertyNames(Set<String> names) {
        HashMap<PropertyName, String> propertyNames = new HashMap<PropertyName, String>();
        for (String name : names) {
            PropertyName propertyName = new PropertyName(name);
            if (propertyNames.containsKey(propertyName)) {
                String existing = (String)propertyNames.remove(propertyName);
                if (existing.length() < name.length()) {
                    propertyNames.put(new PropertyName(existing), existing);
                    continue;
                }
                if (existing.length() > name.length()) {
                    propertyNames.put(propertyName, name);
                    continue;
                }
                if (existing.indexOf(42) <= name.indexOf(42)) {
                    propertyNames.put(new PropertyName(existing), existing);
                    continue;
                }
                propertyNames.put(propertyName, name);
                continue;
            }
            propertyNames.put(propertyName, name);
        }
        return propertyNames.keySet();
    }
}

