/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.configuration;

import io.quarkus.runtime.configuration.NameIterator;
import java.util.Set;

public class PropertiesUtil {
    private PropertiesUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static boolean isPropertyInRoots(String property, Set<String> roots) {
        for (String root : roots) {
            if (!PropertiesUtil.isPropertyInRoot(property, root)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPropertyInRoot(String property, String root) {
        if (property.length() < root.length()) {
            return false;
        }
        if (property.equals(root)) {
            return true;
        }
        if (property.length() == root.length()) {
            return false;
        }
        char c = property.charAt(root.length());
        if (c == '.' || c == '[') {
            return property.startsWith(root);
        }
        return false;
    }

    public static boolean isPropertyQuarkusCompoundName(NameIterator propertyName) {
        return propertyName.getName().startsWith("\"quarkus.");
    }
}

