/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.configuration;

import io.quarkus.runtime.configuration.NameIterator;
import io.smallrye.config.KeyMap;
import java.util.HashSet;
import java.util.Set;

public class PropertiesUtil {
    private PropertiesUtil() {
    }

    public static boolean isPropertyInRoot(Set<String> roots, NameIterator propertyName) {
        block0: for (String root : roots) {
            if (root.length() == 0) {
                return true;
            }
            if (propertyName.getName().length() <= root.length()) continue;
            NameIterator rootNi = new NameIterator(root);
            while (rootNi.hasNext()) {
                String segment = rootNi.getNextSegment();
                if (!propertyName.hasNext()) {
                    propertyName.goToStart();
                    continue block0;
                }
                String nextSegment = propertyName.getNextSegment();
                if (!segment.equals(nextSegment)) {
                    propertyName.goToStart();
                    continue block0;
                }
                rootNi.next();
                propertyName.next();
                if (rootNi.hasNext() || !propertyName.hasNext()) continue;
                propertyName.goToStart();
                return true;
            }
        }
        return false;
    }

    public static boolean isPropertyQuarkusCompoundName(NameIterator propertyName) {
        if (propertyName.hasNext()) {
            return propertyName.getNextSegment().startsWith("quarkus.");
        }
        return false;
    }

    public static void filterUnknown(Set<String> unknownProperties, KeyMap<Boolean> filterPatterns) {
        HashSet<String> toRemove = new HashSet<String>();
        for (String unknownProperty : unknownProperties) {
            if (!filterPatterns.hasRootValue(unknownProperty)) continue;
            toRemove.add(unknownProperty);
        }
        unknownProperties.removeAll(toRemove);
    }
}

