/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.commands;

import io.quarkus.devtools.codestarts.extension.QuarkusExtensionCodestartCatalog;
import io.quarkus.devtools.codestarts.extension.QuarkusExtensionCodestartProjectInput;
import io.quarkus.devtools.codestarts.extension.QuarkusExtensionCodestartProjectInputBuilder;
import io.quarkus.devtools.commands.data.QuarkusCommandException;
import io.quarkus.devtools.commands.data.QuarkusCommandOutcome;
import io.quarkus.devtools.commands.handlers.CreateExtensionCommandHandler;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.maven.utilities.MojoUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Stack;
import java.util.stream.Collectors;
import javax.lang.model.SourceVersion;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Model;

public class CreateExtension {
    public static final String DEFAULT_BOM_GROUP_ID = "io.quarkus";
    public static final String DEFAULT_BOM_ARTIFACT_ID = "quarkus-bom";
    public static final String DEFAULT_BOM_VERSION = "${quarkus.version}";
    public static final String DEFAULT_VERSION = "1.0.0-SNAPSHOT";
    public static final String DEFAULT_CORE_NAMESPACE_ID = "quarkus-";
    public static final String DEFAULT_EXTERNAL_NAMESPACE_ID = "";
    public static final String DEFAULT_QUARKIVERSE_PARENT_GROUP_ID = "io.quarkiverse";
    public static final String DEFAULT_QUARKIVERSE_PARENT_ARTIFACT_ID = "quarkiverse-parent";
    public static final String DEFAULT_QUARKIVERSE_PARENT_VERSION = "7";
    public static final String DEFAULT_QUARKIVERSE_NAMESPACE_ID = "quarkus-";
    private static final String DEFAULT_SUREFIRE_PLUGIN_VERSION = "3.0.0-M5";
    private static final String DEFAULT_COMPILER_PLUGIN_VERSION = "3.8.1";
    private final QuarkusExtensionCodestartProjectInputBuilder builder = QuarkusExtensionCodestartProjectInput.builder();
    private final Path baseDir;
    private final CreateExtensionCommandHandler handler = new CreateExtensionCommandHandler();
    private final EnhancedDataMap data = new EnhancedDataMap();
    private MessageWriter log = MessageWriter.info();
    private String extensionId;
    private String itTestRelativeDir = "integration-tests";
    private String bomRelativeDir = "bom/application";
    private String extensionsRelativeDir = "extensions";

    public CreateExtension(Path baseDir) {
        this.baseDir = Objects.requireNonNull(baseDir, "extensionDirPath is required");
    }

    public CreateExtension groupId(String groupId) {
        this.data.putIfNonEmptyString(QuarkusExtensionCodestartCatalog.QuarkusExtensionData.GROUP_ID, groupId);
        return this;
    }

    public CreateExtension extensionId(String extensionId) {
        if (!StringUtils.isEmpty((CharSequence)extensionId)) {
            this.extensionId = extensionId;
        }
        return this;
    }

    public CreateExtension extensionName(String name) {
        this.data.putIfNonEmptyString(QuarkusExtensionCodestartCatalog.QuarkusExtensionData.EXTENSION_NAME, name);
        return this;
    }

    public CreateExtension version(String version) {
        this.data.putIfNonEmptyString(QuarkusExtensionCodestartCatalog.QuarkusExtensionData.VERSION, version);
        return this;
    }

    public CreateExtension packageName(String packageName) {
        this.data.putIfNonEmptyString(QuarkusExtensionCodestartCatalog.QuarkusExtensionData.PACKAGE_NAME, packageName);
        return this;
    }

    public CreateExtension classNameBase(String classNameBase) {
        this.data.putIfNonEmptyString(QuarkusExtensionCodestartCatalog.QuarkusExtensionData.CLASS_NAME_BASE, classNameBase);
        return this;
    }

    public CreateExtension namespaceId(String extensionArtifactIdPrefix) {
        this.data.putIfNonNull(QuarkusExtensionCodestartCatalog.QuarkusExtensionData.NAMESPACE_ID, extensionArtifactIdPrefix);
        return this;
    }

    public CreateExtension namespaceName(String namespaceName) {
        this.data.putIfNonNull(QuarkusExtensionCodestartCatalog.QuarkusExtensionData.NAMESPACE_NAME, namespaceName);
        return this;
    }

    public CreateExtension parentGroupId(String groupId) {
        this.data.putIfNonEmptyString(QuarkusExtensionCodestartCatalog.QuarkusExtensionData.PARENT_GROUP_ID, groupId);
        return this;
    }

    public CreateExtension parentArtifactId(String artifactId) {
        this.data.putIfNonEmptyString(QuarkusExtensionCodestartCatalog.QuarkusExtensionData.PARENT_ARTIFACT_ID, artifactId);
        return this;
    }

    public CreateExtension parentVersion(String version) {
        this.data.putIfNonEmptyString(QuarkusExtensionCodestartCatalog.QuarkusExtensionData.PARENT_VERSION, version);
        return this;
    }

    public CreateExtension parentRelativePath(String parentRelativePath) {
        this.data.putIfNonEmptyString(QuarkusExtensionCodestartCatalog.QuarkusExtensionData.PARENT_RELATIVE_PATH, parentRelativePath);
        return this;
    }

    public CreateExtension quarkusVersion(String quarkusVersion) {
        this.data.putIfNonEmptyString(QuarkusExtensionCodestartCatalog.QuarkusExtensionData.QUARKUS_VERSION, quarkusVersion);
        return this;
    }

    public CreateExtension quarkusBomGroupId(String quarkusBomGroupId) {
        this.data.putIfNonEmptyString(QuarkusExtensionCodestartCatalog.QuarkusExtensionData.QUARKUS_BOM_GROUP_ID, quarkusBomGroupId);
        return this;
    }

    public CreateExtension quarkusBomArtifactId(String quarkusBomArtifactId) {
        this.data.putIfNonEmptyString(QuarkusExtensionCodestartCatalog.QuarkusExtensionData.QUARKUS_BOM_ARTIFACT_ID, quarkusBomArtifactId);
        return this;
    }

    public CreateExtension quarkusBomVersion(String quarkusBomVersion) {
        this.data.putIfNonEmptyString(QuarkusExtensionCodestartCatalog.QuarkusExtensionData.QUARKUS_BOM_VERSION, quarkusBomVersion);
        return this;
    }

    public CreateExtension withoutUnitTest(boolean withoutUnitTest) {
        this.builder.withoutUnitTest(withoutUnitTest);
        return this;
    }

    public CreateExtension withoutDevModeTest(boolean withoutDevModeTest) {
        this.builder.withoutDevModeTest(withoutDevModeTest);
        return this;
    }

    public CreateExtension withoutIntegrationTests(boolean withoutIntegrationTest) {
        this.builder.withoutIntegrationTests(withoutIntegrationTest);
        return this;
    }

    public CreateExtension itTestRelativeDir(String itTestRelativeDir) {
        if (!StringUtils.isEmpty((CharSequence)itTestRelativeDir)) {
            this.itTestRelativeDir = itTestRelativeDir;
        }
        return this;
    }

    public CreateExtension bomRelativeDir(String bomRelativeDir) {
        if (!StringUtils.isEmpty((CharSequence)bomRelativeDir)) {
            this.bomRelativeDir = bomRelativeDir;
        }
        return this;
    }

    public CreateExtension extensionsRelativeDir(String extensionsRelativeDir) {
        if (!StringUtils.isEmpty((CharSequence)extensionsRelativeDir)) {
            this.extensionsRelativeDir = extensionsRelativeDir;
        }
        return this;
    }

    public QuarkusCommandOutcome execute() throws QuarkusCommandException {
        Model itTestModel;
        Path workingDir = CreateExtension.resolveWorkingDir(this.baseDir);
        Model baseModel = CreateExtension.resolveModel(this.baseDir);
        LayoutType layoutType = CreateExtension.detectLayoutType(baseModel, this.data.getStringValue(QuarkusExtensionCodestartCatalog.QuarkusExtensionData.GROUP_ID).orElse(null));
        this.data.putIfAbsent(QuarkusExtensionCodestartCatalog.QuarkusExtensionData.NAMESPACE_ID, this.getDefaultNamespaceId(layoutType));
        this.ensureRequiredStringData(QuarkusExtensionCodestartCatalog.QuarkusExtensionData.EXTENSION_ID, this.resolveExtensionId());
        this.data.putIfAbsent(QuarkusExtensionCodestartCatalog.QuarkusExtensionData.EXTENSION_NAME, CreateExtension.toCapWords(this.extensionId));
        this.data.putIfAbsent(QuarkusExtensionCodestartCatalog.QuarkusExtensionData.NAMESPACE_NAME, this.computeDefaultNamespaceName(this.data.getRequiredStringValue(QuarkusExtensionCodestartCatalog.QuarkusExtensionData.NAMESPACE_ID)));
        this.data.putIfAbsent(QuarkusExtensionCodestartCatalog.QuarkusExtensionData.CLASS_NAME_BASE, CreateExtension.toCapCamelCase(this.extensionId));
        String runtimeArtifactId = this.getRuntimeArtifactIdFromData();
        this.ensureRequiredStringData(QuarkusExtensionCodestartCatalog.QuarkusExtensionData.GROUP_ID, CreateExtension.resolveGroupId(baseModel));
        this.ensureRequiredStringData(QuarkusExtensionCodestartCatalog.QuarkusExtensionData.VERSION, CreateExtension.resolveVersion(baseModel));
        this.ensureRequiredStringData(QuarkusExtensionCodestartCatalog.QuarkusExtensionData.PACKAGE_NAME, CreateExtension.resolveExtensionPackage(this.data.getRequiredStringValue(QuarkusExtensionCodestartCatalog.QuarkusExtensionData.GROUP_ID), this.extensionId));
        String groupId = this.data.getRequiredStringValue(QuarkusExtensionCodestartCatalog.QuarkusExtensionData.GROUP_ID);
        String extensionDirName = runtimeArtifactId;
        switch (layoutType) {
            case QUARKUS_CORE: 
            case OTHER_PLATFORM: {
                extensionDirName = this.extensionId;
                Model extensionsParentModel = CreateExtensionCommandHandler.readPom(workingDir.resolve(this.extensionsRelativeDir));
                this.data.putIfAbsent(QuarkusExtensionCodestartCatalog.QuarkusExtensionData.PROPERTIES_FROM_PARENT, (Object)true);
                this.ensureRequiredStringData(QuarkusExtensionCodestartCatalog.QuarkusExtensionData.PARENT_GROUP_ID, CreateExtension.resolveGroupId(extensionsParentModel));
                this.ensureRequiredStringData(QuarkusExtensionCodestartCatalog.QuarkusExtensionData.PARENT_ARTIFACT_ID, CreateExtension.resolveArtifactId(extensionsParentModel));
                this.ensureRequiredStringData(QuarkusExtensionCodestartCatalog.QuarkusExtensionData.PARENT_VERSION, CreateExtension.resolveVersion(extensionsParentModel));
                this.data.putIfAbsent(QuarkusExtensionCodestartCatalog.QuarkusExtensionData.PARENT_RELATIVE_PATH, "../pom.xml");
                itTestModel = CreateExtensionCommandHandler.readPom(workingDir.resolve(this.itTestRelativeDir));
                break;
            }
            case QUARKIVERSE: {
                this.data.putIfAbsent(QuarkusExtensionCodestartCatalog.QuarkusExtensionData.PARENT_GROUP_ID, DEFAULT_QUARKIVERSE_PARENT_GROUP_ID);
                this.data.putIfAbsent(QuarkusExtensionCodestartCatalog.QuarkusExtensionData.PARENT_ARTIFACT_ID, DEFAULT_QUARKIVERSE_PARENT_ARTIFACT_ID);
                this.data.putIfAbsent(QuarkusExtensionCodestartCatalog.QuarkusExtensionData.PARENT_VERSION, DEFAULT_QUARKIVERSE_PARENT_VERSION);
                this.data.putIfAbsent(QuarkusExtensionCodestartCatalog.QuarkusExtensionData.QUARKUS_BOM_GROUP_ID, DEFAULT_BOM_GROUP_ID);
                this.data.putIfAbsent(QuarkusExtensionCodestartCatalog.QuarkusExtensionData.QUARKUS_BOM_ARTIFACT_ID, DEFAULT_BOM_ARTIFACT_ID);
                this.data.putIfAbsent(QuarkusExtensionCodestartCatalog.QuarkusExtensionData.QUARKUS_BOM_VERSION, DEFAULT_BOM_VERSION);
                this.data.putIfAbsent(QuarkusExtensionCodestartCatalog.QuarkusExtensionData.MAVEN_COMPILER_PLUGIN_VERSION, DEFAULT_COMPILER_PLUGIN_VERSION);
                this.ensureRequiredStringData(QuarkusExtensionCodestartCatalog.QuarkusExtensionData.QUARKUS_VERSION);
                this.builder.addCodestart(QuarkusExtensionCodestartCatalog.Code.QUARKIVERSE.key());
                this.builder.addCodestart(QuarkusExtensionCodestartCatalog.Tooling.GIT.key());
                itTestModel = this.getStandaloneTempModel(workingDir, runtimeArtifactId);
                break;
            }
            default: {
                this.data.putIfAbsent(QuarkusExtensionCodestartCatalog.QuarkusExtensionData.QUARKUS_BOM_GROUP_ID, DEFAULT_BOM_GROUP_ID);
                this.data.putIfAbsent(QuarkusExtensionCodestartCatalog.QuarkusExtensionData.QUARKUS_BOM_ARTIFACT_ID, DEFAULT_BOM_ARTIFACT_ID);
                this.data.putIfAbsent(QuarkusExtensionCodestartCatalog.QuarkusExtensionData.QUARKUS_BOM_VERSION, DEFAULT_BOM_VERSION);
                this.data.putIfAbsent(QuarkusExtensionCodestartCatalog.QuarkusExtensionData.MAVEN_SUREFIRE_PLUGIN_VERSION, DEFAULT_SUREFIRE_PLUGIN_VERSION);
                this.data.putIfAbsent(QuarkusExtensionCodestartCatalog.QuarkusExtensionData.MAVEN_COMPILER_PLUGIN_VERSION, DEFAULT_COMPILER_PLUGIN_VERSION);
                this.ensureRequiredStringData(QuarkusExtensionCodestartCatalog.QuarkusExtensionData.QUARKUS_VERSION);
                itTestModel = this.getStandaloneTempModel(workingDir, runtimeArtifactId);
            }
        }
        this.ensureRequiredStringData(QuarkusExtensionCodestartCatalog.QuarkusExtensionData.IT_PARENT_GROUP_ID, CreateExtension.resolveGroupId(itTestModel));
        this.ensureRequiredStringData(QuarkusExtensionCodestartCatalog.QuarkusExtensionData.IT_PARENT_ARTIFACT_ID, CreateExtension.resolveArtifactId(itTestModel));
        this.ensureRequiredStringData(QuarkusExtensionCodestartCatalog.QuarkusExtensionData.IT_PARENT_VERSION, CreateExtension.resolveVersion(itTestModel));
        this.ensureRequiredStringData(QuarkusExtensionCodestartCatalog.QuarkusExtensionData.IT_PARENT_RELATIVE_PATH, "../pom.xml");
        this.builder.addData((Map)this.data);
        this.log.info("\nDetected layout type is '%s' ", new Object[]{layoutType.toString().toLowerCase()});
        this.log.info("Generated runtime artifactId is '%s'\n", new Object[]{runtimeArtifactId});
        if (LayoutType.QUARKUS_CORE.equals((Object)layoutType) || LayoutType.OTHER_PLATFORM.equals((Object)layoutType)) {
            Path extensionsDir = workingDir.resolve(this.extensionsRelativeDir);
            Path itTestDir = workingDir.resolve(this.itTestRelativeDir);
            Path bomDir = workingDir.resolve(this.bomRelativeDir);
            return this.handler.execute(this.log, groupId, runtimeArtifactId, this.builder.build(), extensionsDir.resolve(extensionDirName), extensionsDir, itTestDir, bomDir);
        }
        return this.handler.execute(this.log, groupId, runtimeArtifactId, this.builder.build(), workingDir.resolve(extensionDirName));
    }

    private String resolveExtensionId() {
        String namespaceId = this.data.getRequiredStringValue(QuarkusExtensionCodestartCatalog.QuarkusExtensionData.NAMESPACE_ID);
        if (this.extensionId.startsWith(namespaceId)) {
            this.extensionId = this.extensionId.substring(namespaceId.length());
        }
        return this.extensionId;
    }

    private String getDefaultNamespaceId(LayoutType layoutType) {
        switch (layoutType) {
            case QUARKIVERSE: {
                return "quarkus-";
            }
            case QUARKUS_CORE: {
                return "quarkus-";
            }
        }
        return DEFAULT_EXTERNAL_NAMESPACE_ID;
    }

    private String computeDefaultNamespaceName(String namespaceId) {
        if (StringUtils.isEmpty((CharSequence)namespaceId)) {
            return DEFAULT_EXTERNAL_NAMESPACE_ID;
        }
        return CreateExtension.toCapWords(namespaceId) + " - ";
    }

    public static Model resolveModel(Path dir) throws QuarkusCommandException {
        Path workingDir = CreateExtension.resolveWorkingDir(dir);
        Path basePom = workingDir.resolve("pom.xml");
        if (!Files.isRegularFile(basePom, new LinkOption[0])) {
            return null;
        }
        try {
            return MojoUtils.readPom(basePom.toFile());
        }
        catch (IOException e) {
            throw new QuarkusCommandException("Error while reading base pom.xml", e);
        }
    }

    private Model getStandaloneTempModel(Path workingDir, String runtimeArtifactId) {
        Model model = new Model();
        model.setGroupId(this.data.getRequiredStringValue(QuarkusExtensionCodestartCatalog.QuarkusExtensionData.GROUP_ID));
        model.setArtifactId(runtimeArtifactId + "-parent");
        model.setVersion(this.data.getStringValue(QuarkusExtensionCodestartCatalog.QuarkusExtensionData.VERSION).orElse(DEFAULT_VERSION));
        model.setPomFile(workingDir.resolve("pom.xml").toFile());
        return model;
    }

    private String getRuntimeArtifactIdFromData() {
        return this.data.getStringValue(QuarkusExtensionCodestartCatalog.QuarkusExtensionData.NAMESPACE_ID).orElse(DEFAULT_EXTERNAL_NAMESPACE_ID) + this.data.getRequiredStringValue(QuarkusExtensionCodestartCatalog.QuarkusExtensionData.EXTENSION_ID);
    }

    private static Path resolveWorkingDir(Path dir) {
        return "extensions".equals(dir.getFileName().toString()) ? dir.resolve("..") : dir;
    }

    public static LayoutType detectLayoutType(Model basePom, String groupId) {
        if (basePom != null) {
            if (basePom.getArtifactId().endsWith("quarkus-parent")) {
                return LayoutType.QUARKUS_CORE;
            }
            if (basePom.getModules().stream().anyMatch(s -> s.contains("bom"))) {
                return LayoutType.OTHER_PLATFORM;
            }
        }
        if (CreateExtension.isQuarkiverseGroupId(groupId)) {
            return LayoutType.QUARKIVERSE;
        }
        return LayoutType.STANDALONE;
    }

    public static boolean isQuarkiverseGroupId(String groupId) {
        return groupId != null && groupId.contains(DEFAULT_QUARKIVERSE_PARENT_GROUP_ID);
    }

    public static String extractQuarkiverseExtensionId(String groupId) {
        return groupId.replace("io.quarkiverse.", DEFAULT_EXTERNAL_NAMESPACE_ID);
    }

    private void ensureRequiredStringData(QuarkusExtensionCodestartCatalog.QuarkusExtensionData key) throws QuarkusCommandException {
        if (!this.data.containsNonEmptyStringForKey(key)) {
            throw new QuarkusCommandException("'" + key.toString() + "' value is required.");
        }
    }

    private void ensureRequiredStringData(QuarkusExtensionCodestartCatalog.QuarkusExtensionData key, String detectedValue) throws QuarkusCommandException {
        if (!this.data.containsNonEmptyStringForKey(key)) {
            if (StringUtils.isEmpty((CharSequence)detectedValue)) {
                throw new QuarkusCommandException("You need to define  '" + key.toString() + "' because it was not found in the project hierarchy.");
            }
            this.data.putIfNonEmptyString(key, detectedValue);
        }
    }

    static String resolveExtensionPackage(String groupId, String artifactId) {
        Stack<String> segments = new Stack<String>();
        for (String segment : groupId.split("[.\\-]+")) {
            if (!segments.isEmpty() && ((String)segments.peek()).equals(segment)) continue;
            segments.add(segment);
        }
        for (String segment : artifactId.split("[.\\-]+")) {
            if (segments.contains(segment)) continue;
            segments.add(segment);
        }
        return segments.stream().map(s -> s.toLowerCase(Locale.ROOT)).map(s -> SourceVersion.isKeyword(s) ? s + "_" : s).collect(Collectors.joining("."));
    }

    static String resolveGroupId(Model basePom) {
        return basePom != null ? (basePom.getGroupId() != null ? basePom.getGroupId() : (basePom.getParent() != null && basePom.getParent().getGroupId() != null ? basePom.getParent().getGroupId() : null)) : null;
    }

    static String resolveArtifactId(Model basePom) {
        return basePom != null ? (basePom.getArtifactId() != null ? basePom.getArtifactId() : (basePom.getParent() != null && basePom.getParent().getArtifactId() != null ? basePom.getParent().getArtifactId() : null)) : null;
    }

    static String resolveVersion(Model basePom) {
        return basePom != null ? (basePom.getVersion() != null ? basePom.getVersion() : (basePom.getParent() != null && basePom.getParent().getVersion() != null ? basePom.getParent().getVersion() : DEFAULT_VERSION)) : DEFAULT_VERSION;
    }

    static String toCapCamelCase(String name) {
        StringBuilder sb = new StringBuilder(name.length());
        for (String segment : name.split("[.\\-]+")) {
            sb.append(Character.toUpperCase(segment.charAt(0)));
            if (segment.length() <= 1) continue;
            sb.append(segment.substring(1));
        }
        return sb.toString();
    }

    static String toCapWords(String name) {
        StringBuilder sb = new StringBuilder(name.length());
        for (String segment : name.split("[.\\-]+")) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(Character.toUpperCase(segment.charAt(0)));
            if (segment.length() <= 1) continue;
            sb.append(segment.substring(1));
        }
        return sb.toString();
    }

    private static class EnhancedDataMap
    extends HashMap<String, Object> {
        private EnhancedDataMap() {
        }

        public Optional<String> getStringValue(QuarkusExtensionCodestartCatalog.QuarkusExtensionData key) {
            Object o = this.get(key.key());
            return Optional.ofNullable(o instanceof String ? (String)o : null);
        }

        @Override
        public void putIfAbsent(QuarkusExtensionCodestartCatalog.QuarkusExtensionData dataKey, Object value) {
            this.putIfAbsent(dataKey.key(), value);
        }

        public void putIfNonEmptyString(QuarkusExtensionCodestartCatalog.QuarkusExtensionData dataKey, String value) {
            if (!StringUtils.isEmpty((CharSequence)value)) {
                this.put(dataKey.key(), value);
            }
        }

        public void putIfNonNull(QuarkusExtensionCodestartCatalog.QuarkusExtensionData dataKey, String value) {
            if (value != null) {
                this.put(dataKey.key(), value);
            }
        }

        public String getRequiredStringValue(QuarkusExtensionCodestartCatalog.QuarkusExtensionData key) {
            return Objects.requireNonNull((String)this.getStringValue(key).orElse(null), key.key() + " is required");
        }

        public boolean containsNonEmptyStringForKey(QuarkusExtensionCodestartCatalog.QuarkusExtensionData dataKey) {
            return !StringUtils.isEmpty((CharSequence)this.getStringValue(dataKey).orElse(null));
        }

        public boolean containsKey(QuarkusExtensionCodestartCatalog.QuarkusExtensionData dataKey) {
            return this.containsKey(dataKey.key());
        }
    }

    public static enum LayoutType {
        OTHER_PLATFORM,
        QUARKUS_CORE,
        QUARKIVERSE,
        STANDALONE;

    }
}

