/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.project;

import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.util.DependencyNodeUtils;
import io.quarkus.devtools.project.QuarkusProjectHelper;
import io.quarkus.platform.catalog.processor.CatalogProcessor;
import io.quarkus.platform.catalog.processor.ExtensionProcessor;
import io.quarkus.platform.descriptor.loader.json.ResourceLoader;
import io.quarkus.platform.descriptor.loader.json.ResourceLoaders;
import io.quarkus.registry.catalog.Extension;
import io.quarkus.registry.catalog.ExtensionCatalog;
import io.quarkus.registry.config.PropertiesUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.eclipse.aether.artifact.Artifact;

public final class CodestartResourceLoadersBuilder {
    private static final String BASE_CODESTARTS_ARTIFACT_PROPERTY = "quarkus-base-codestart-artifact";
    private static final String BASE_CODESTARTS_ARTIFACT_PROPERTIES_NAME = "/quarkus-devtools-base-codestarts.properties";
    private static final String BASE_CODESTARTS_ARTIFACT_COORDS = CodestartResourceLoadersBuilder.retrieveBaseCodestartsArtifactCoords();
    private ExtensionCatalog catalog = null;
    private MavenArtifactResolver artifactResolver = QuarkusProjectHelper.artifactResolver();
    private String baseCodestartsArtifactCoords = BASE_CODESTARTS_ARTIFACT_COORDS;
    private Collection<String> extraCodestartsArtifactCoords = new ArrayList<String>();

    private static String retrieveBaseCodestartsArtifactCoords() {
        String string;
        block9: {
            String artifact = PropertiesUtil.getProperty((String)BASE_CODESTARTS_ARTIFACT_PROPERTY);
            if (artifact != null) {
                return artifact;
            }
            InputStream resource = QuarkusProjectHelper.class.getResourceAsStream(BASE_CODESTARTS_ARTIFACT_PROPERTIES_NAME);
            try {
                Properties properties = new Properties();
                Objects.requireNonNull(resource, "/quarkus-devtools-base-codestarts.properties resource not found.");
                properties.load(resource);
                string = Objects.requireNonNull(properties.getProperty("artifact"), "base codestarts 'artifact' property not found");
                if (resource == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (resource != null) {
                        try {
                            resource.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Couldn't load the base codestarts artifact properties", e);
                }
            }
            resource.close();
        }
        return string;
    }

    private CodestartResourceLoadersBuilder() {
    }

    public static CodestartResourceLoadersBuilder codestartLoadersBuilder() {
        return new CodestartResourceLoadersBuilder();
    }

    public static List<ResourceLoader> getCodestartResourceLoaders() {
        return CodestartResourceLoadersBuilder.codestartLoadersBuilder().build();
    }

    public static List<ResourceLoader> getCodestartResourceLoaders(ExtensionCatalog catalog) {
        return CodestartResourceLoadersBuilder.codestartLoadersBuilder().catalog(catalog).build();
    }

    public CodestartResourceLoadersBuilder catalog(ExtensionCatalog catalog) {
        this.catalog = catalog;
        return this;
    }

    public CodestartResourceLoadersBuilder artifactResolver(MavenArtifactResolver artifactResolver) {
        this.artifactResolver = artifactResolver;
        return this;
    }

    public CodestartResourceLoadersBuilder baseCodestartsArtifactCoords(String baseCodestartsArtifactCoords) {
        this.baseCodestartsArtifactCoords = baseCodestartsArtifactCoords;
        return this;
    }

    public CodestartResourceLoadersBuilder noBaseCodestarts() {
        this.baseCodestartsArtifactCoords = null;
        return this;
    }

    public CodestartResourceLoadersBuilder addExtraCodestartsArtifactCoords(Collection<String> extraCodestartsArtifactCoords) {
        this.extraCodestartsArtifactCoords.addAll(extraCodestartsArtifactCoords);
        return this;
    }

    public List<ResourceLoader> build() {
        return CodestartResourceLoadersBuilder.getCodestartResourceLoaders(this.baseCodestartsArtifactCoords, this.extraCodestartsArtifactCoords, this.catalog, this.artifactResolver);
    }

    private static List<ResourceLoader> getCodestartResourceLoaders(String baseCodestartsArtifactCoords, Collection<String> extraCodestartsArtifactCoords, ExtensionCatalog catalog, MavenArtifactResolver artifactResolver) {
        ArrayList<String> coords = new ArrayList<String>(extraCodestartsArtifactCoords);
        if (baseCodestartsArtifactCoords != null) {
            coords.add(baseCodestartsArtifactCoords);
        }
        return CodestartResourceLoadersBuilder.getCodestartResourceLoaders(coords, catalog, artifactResolver);
    }

    private static List<ResourceLoader> getCodestartResourceLoaders(Collection<String> extraCodestartsArtifactCoords, ExtensionCatalog catalog, MavenArtifactResolver mvn) {
        LinkedHashMap<String, Artifact> codestartsArtifacts = new LinkedHashMap<String, Artifact>();
        if (catalog != null) {
            String artifactCoords;
            Object e2;
            for (Object e2 : catalog.getExtensions()) {
                artifactCoords = ExtensionProcessor.getCodestartArtifact((Extension)e2);
                if (artifactCoords == null || codestartsArtifacts.containsKey(artifactCoords)) continue;
                codestartsArtifacts.put(artifactCoords, DependencyNodeUtils.toArtifact((String)artifactCoords));
            }
            List<String> catalogCodestartArtifacts = CatalogProcessor.getCodestartArtifacts(catalog);
            e2 = catalogCodestartArtifacts.iterator();
            while (e2.hasNext()) {
                artifactCoords = (String)e2.next();
                if (codestartsArtifacts.containsKey(artifactCoords)) continue;
                codestartsArtifacts.put(artifactCoords, DependencyNodeUtils.toArtifact((String)artifactCoords));
            }
        }
        for (String codestartArtifactCoords : extraCodestartsArtifactCoords) {
            codestartsArtifacts.put(codestartArtifactCoords, DependencyNodeUtils.toArtifact((String)codestartArtifactCoords));
        }
        ArrayList<ResourceLoader> codestartResourceLoaders = new ArrayList<ResourceLoader>(codestartsArtifacts.size());
        for (Artifact a : codestartsArtifacts.values()) {
            try {
                File artifactFile = mvn.resolve(a).getArtifact().getFile();
                codestartResourceLoaders.add(ResourceLoaders.resolveFileResourceLoader(artifactFile));
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to resolve codestart artifact " + a, e);
            }
        }
        return codestartResourceLoaders;
    }
}

