/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.project.buildfile;

import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalProject;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.devtools.project.BuildTool;
import io.quarkus.devtools.project.CodestartResourceLoadersBuilder;
import io.quarkus.devtools.project.QuarkusProject;
import io.quarkus.devtools.project.QuarkusProjectHelper;
import io.quarkus.devtools.project.buildfile.BuildFile;
import io.quarkus.devtools.project.extensions.Extensions;
import io.quarkus.maven.ArtifactCoords;
import io.quarkus.maven.ArtifactKey;
import io.quarkus.maven.utilities.MojoUtils;
import io.quarkus.platform.descriptor.loader.json.ResourceLoader;
import io.quarkus.platform.tools.ToolsUtils;
import io.quarkus.registry.ExtensionCatalogResolver;
import io.quarkus.registry.RegistryResolutionException;
import io.quarkus.registry.catalog.ExtensionCatalog;
import io.quarkus.registry.config.RegistriesConfig;
import io.quarkus.registry.util.PlatformArtifacts;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;

public class MavenProjectBuildFile
extends BuildFile {
    private static final Pattern PROPERTY_PATTERN = Pattern.compile("\\$\\{(.+)}");
    private final Model model;
    private final List<ArtifactCoords> managedDependencies;
    private final Properties projectProps;
    private Supplier<List<ArtifactCoords>> projectDepsSupplier;
    private List<ArtifactCoords> dependencies;
    private List<ArtifactCoords> importedPlatforms;

    public static QuarkusProject getProject(Path projectDir, MessageWriter log, Supplier<String> defaultQuarkusVersion) {
        Model projectModel;
        DefaultArtifact projectPom;
        MavenArtifactResolver mvnResolver = MavenProjectBuildFile.getMavenResolver(projectDir);
        LocalProject currentProject = mvnResolver.getMavenContext().getCurrentProject();
        if (currentProject != null && MavenProjectBuildFile.isSameFile(projectDir, currentProject.getDir())) {
            projectPom = new DefaultArtifact(currentProject.getGroupId(), currentProject.getArtifactId(), null, "pom", currentProject.getVersion());
            projectModel = currentProject.getRawModel();
        } else {
            projectPom = null;
            projectModel = null;
        }
        return MavenProjectBuildFile.getProject(projectPom, projectModel, projectDir, projectModel == null ? new Properties() : projectModel.getProperties(), mvnResolver, log, defaultQuarkusVersion);
    }

    public static QuarkusProject getProject(Artifact projectPom, Model projectModel, Path projectDir, Properties projectProps, MavenArtifactResolver mvnResolver, MessageWriter log, Supplier<String> defaultQuarkusVersion) {
        ExtensionCatalog extensionCatalog;
        String quarkusVersion;
        Supplier<List<ArtifactCoords>> deps;
        List<ArtifactCoords> managedDeps;
        if (projectPom == null) {
            managedDeps = Collections.emptyList();
            deps = () -> Collections.emptyList();
            quarkusVersion = defaultQuarkusVersion.get();
        } else {
            ArtifactDescriptorResult descriptor = MavenProjectBuildFile.describe(mvnResolver, projectPom);
            managedDeps = MavenProjectBuildFile.toArtifactCoords(descriptor.getManagedDependencies());
            deps = () -> MavenProjectBuildFile.toArtifactCoords(descriptor.getDependencies());
            quarkusVersion = MavenProjectBuildFile.getQuarkusVersion(managedDeps);
        }
        ExtensionCatalogResolver catalogResolver = QuarkusProjectHelper.getCatalogResolver(mvnResolver, log);
        if (catalogResolver.hasRegistries()) {
            try {
                extensionCatalog = catalogResolver.resolveExtensionCatalog(quarkusVersion);
            }
            catch (RegistryResolutionException e) {
                throw new RuntimeException("Failed to resolve extension catalog", e);
            }
        } else {
            List<ArtifactCoords> importedPlatforms = MavenProjectBuildFile.collectPlatformDescriptors(managedDeps, log);
            extensionCatalog = importedPlatforms.isEmpty() ? ToolsUtils.resolvePlatformDescriptorDirectly(null, null, quarkusVersion, mvnResolver, log) : ToolsUtils.mergePlatforms(importedPlatforms, mvnResolver);
        }
        MavenProjectBuildFile extensionManager = new MavenProjectBuildFile(projectDir, extensionCatalog, projectModel, deps, managedDeps, projectProps);
        List<ResourceLoader> codestartResourceLoaders = CodestartResourceLoadersBuilder.codestartLoadersBuilder().catalog(extensionCatalog).artifactResolver(mvnResolver).build();
        return QuarkusProject.of(projectDir, extensionCatalog, codestartResourceLoaders, log, extensionManager);
    }

    private static MavenArtifactResolver getMavenResolver(Path projectDir) {
        RegistriesConfig toolsConfig = QuarkusProjectHelper.toolsConfig();
        try {
            return ((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)MavenArtifactResolver.builder().setArtifactTransferLogging(toolsConfig.isDebug())).setCurrentProject(projectDir.toString())).setPreferPomsFromWorkspace(true)).build();
        }
        catch (BootstrapMavenException e) {
            throw new RuntimeException("Failed to initialize Maven artifact resolver", e);
        }
    }

    private static String getQuarkusVersion(List<ArtifactCoords> managedDeps) {
        for (ArtifactCoords a : managedDeps) {
            if (!a.getArtifactId().endsWith("quarkus-core") || !a.getGroupId().equals("io.quarkus")) continue;
            return a.getVersion();
        }
        return null;
    }

    private static List<ArtifactCoords> toArtifactCoords(List<Dependency> deps) {
        ArrayList<ArtifactCoords> result = new ArrayList<ArtifactCoords>(deps.size());
        for (Dependency dep : deps) {
            Artifact a = dep.getArtifact();
            result.add(new ArtifactCoords(a.getGroupId(), a.getArtifactId(), a.getClassifier(), a.getExtension(), a.getVersion()));
        }
        return result;
    }

    private static ArtifactDescriptorResult describe(MavenArtifactResolver resolver, Artifact projectArtifact) {
        try {
            return resolver.resolveDescriptor(projectArtifact);
        }
        catch (BootstrapMavenException e) {
            throw new RuntimeException("Failed to resolve descriptor for " + projectArtifact, e);
        }
    }

    private static List<ArtifactCoords> collectPlatformDescriptors(List<ArtifactCoords> managedDeps, MessageWriter log) {
        if (managedDeps.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ArtifactCoords> result = new ArrayList<ArtifactCoords>(4);
        for (ArtifactCoords c : managedDeps) {
            if (!PlatformArtifacts.isCatalogArtifact((ArtifactCoords)c)) continue;
            result.add(c);
        }
        return result;
    }

    private static boolean isSameFile(Path p1, Path p2) {
        try {
            return Files.isSameFile(p1, p2);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to compare " + p1 + " to " + p2, e);
        }
    }

    private MavenProjectBuildFile(Path projectDirPath, ExtensionCatalog extensionsCatalog, Model model, Supplier<List<ArtifactCoords>> projectDeps, List<ArtifactCoords> projectManagedDeps, Properties projectProps) {
        super(projectDirPath, extensionsCatalog);
        this.model = model;
        this.projectDepsSupplier = projectDeps;
        this.managedDependencies = projectManagedDeps;
        this.projectProps = projectProps;
    }

    @Override
    public BuildTool getBuildTool() {
        return BuildTool.MAVEN;
    }

    @Override
    protected boolean addDependency(ArtifactCoords coords, boolean managed) {
        org.apache.maven.model.Dependency d = new org.apache.maven.model.Dependency();
        d.setGroupId(coords.getGroupId());
        d.setArtifactId(coords.getArtifactId());
        if (!managed) {
            d.setVersion(coords.getVersion());
        }
        if (coords.getClassifier() != null && !coords.getClassifier().isEmpty()) {
            d.setClassifier(coords.getClassifier());
        }
        d.setType(coords.getType());
        if ("pom".equalsIgnoreCase(coords.getType())) {
            d.setScope("import");
            DependencyManagement dependencyManagement = this.model().getDependencyManagement();
            if (dependencyManagement == null) {
                dependencyManagement = new DependencyManagement();
                this.model().setDependencyManagement(dependencyManagement);
            }
            if (dependencyManagement.getDependencies().stream().noneMatch(thisDep -> d.getManagementKey().equals(this.resolveKey((org.apache.maven.model.Dependency)thisDep)))) {
                dependencyManagement.addDependency(d);
                if (!this.getManagedDependencies().contains(coords)) {
                    this.getManagedDependencies().add(coords);
                }
                return true;
            }
        } else if (this.model().getDependencies().stream().noneMatch(thisDep -> d.getManagementKey().equals(thisDep.getManagementKey()))) {
            this.model().addDependency(d);
            if (!this.getDependencies().contains(coords)) {
                this.getDependencies().add(coords);
            }
            return true;
        }
        return false;
    }

    @Override
    protected void removeDependency(ArtifactKey key) throws IOException {
        if (this.model() != null) {
            Iterator<ArtifactCoords> i = this.getDependencies().iterator();
            while (i.hasNext()) {
                ArtifactCoords a = i.next();
                if (a.getKey().equals((Object)key)) {
                    i.remove();
                    break;
                }
                this.model().getDependencies().removeIf(d -> Objects.equals(Extensions.toKey(d), key));
            }
        }
    }

    @Override
    protected List<ArtifactCoords> getDependencies() {
        if (this.dependencies == null) {
            this.dependencies = this.projectDepsSupplier.get();
            this.projectDepsSupplier = null;
        }
        return this.dependencies;
    }

    @Override
    public final Collection<ArtifactCoords> getInstalledPlatforms() throws IOException {
        if (this.importedPlatforms == null) {
            ArrayList<ArtifactCoords> tmp = new ArrayList<ArtifactCoords>(4);
            for (ArtifactCoords c : this.getManagedDependencies()) {
                if (!PlatformArtifacts.isCatalogArtifact((ArtifactCoords)c)) continue;
                tmp.add(PlatformArtifacts.getBomArtifactForCatalog((ArtifactCoords)c));
            }
            this.importedPlatforms = tmp;
        }
        return this.importedPlatforms;
    }

    protected List<ArtifactCoords> getManagedDependencies() {
        return this.managedDependencies;
    }

    @Override
    protected void writeToDisk() throws IOException {
        if (this.model == null) {
            return;
        }
        try (ByteArrayOutputStream pomOutputStream = new ByteArrayOutputStream();){
            MojoUtils.write(this.model(), pomOutputStream);
            this.writeToProjectFile(BuildTool.MAVEN.getDependenciesFile(), pomOutputStream.toByteArray());
        }
    }

    @Override
    protected String getProperty(String propertyName) {
        return this.projectProps.getProperty(propertyName);
    }

    @Override
    protected void refreshData() {
    }

    private Model model() {
        return this.model;
    }

    private String resolveKey(org.apache.maven.model.Dependency dependency) {
        String resolvedGroupId = this.toResolvedProperty(dependency.getGroupId());
        String resolvedArtifactId = this.toResolvedProperty(dependency.getArtifactId());
        String resolvedVersion = this.toResolvedProperty(dependency.getVersion());
        if (!(resolvedGroupId.equals(dependency.getGroupId()) && resolvedArtifactId.equals(dependency.getArtifactId()) && resolvedVersion.equals(dependency.getVersion()))) {
            return resolvedGroupId + ":" + resolvedArtifactId + ":" + dependency.getType() + (String)(dependency.getClassifier() != null ? ":" + dependency.getClassifier() : "");
        }
        return dependency.getManagementKey();
    }

    private String toResolvedProperty(String value) {
        Matcher matcher = PROPERTY_PATTERN.matcher(value);
        if (matcher.matches()) {
            String property = this.getProperty(matcher.group(1));
            return property == null ? value : property;
        }
        return value;
    }
}

